/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import org.lsmp.djep.djep.DSymbolTable;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixNodeFactory;
import org.lsmp.djep.matrixJep.SpecialPreProcessorI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.xjep.CommandVisitorI;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.function.PostfixMathCommandI;

public class MatrixPreprocessor
implements ParserVisitor {
    private MatrixJep mjep;
    private MatrixNodeFactory nf;
    private DSymbolTable vt;

    public MatrixNodeI preprocess(Node node, MatrixJep mdjep) throws ParseException {
        this.mjep = mdjep;
        this.nf = (MatrixNodeFactory)mdjep.getNodeFactory();
        this.vt = (DSymbolTable)mdjep.getSymbolTable();
        return (MatrixNodeI)node.jjtAccept((ParserVisitor)this, null);
    }

    public MatrixNodeI[] visitChildrenAsArray(Node node, Object data) throws ParseException {
        int nchild = node.jjtGetNumChildren();
        MatrixNodeI[] children = new MatrixNodeI[nchild];
        int i = 0;
        while (i < nchild) {
            MatrixNodeI no;
            children[i] = no = (MatrixNodeI)node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        return children;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return null;
    }

    public Object visit(ASTConstant node, Object data) throws ParseException {
        return this.nf.buildConstantNode(node.getValue());
    }

    public Object visit(ASTVarNode node, Object data) throws ParseException {
        return this.nf.buildVariableNode(this.vt.getVar(node.getName()));
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc instanceof SpecialPreProcessorI) {
            SpecialPreProcessorI spp = (SpecialPreProcessorI)node.getPFMC();
            return spp.preprocess(node, this, this.mjep, this.nf);
        }
        if (node.isOperator()) {
            return this.visitOp(node, data);
        }
        if (node.getPFMC() instanceof CommandVisitorI) {
            throw new IllegalArgumentException("MatrixPreprocessor: encountered and instance of CommandVisitorI  for function " + node.getName());
        }
        MatrixNodeI[] children = this.visitChildrenAsArray((Node)node, data);
        ASTMFunNode res = (ASTMFunNode)this.nf.buildFunctionNode(node, (Node[])children);
        return res;
    }

    public Object visitOp(ASTFunNode node, Object data) throws ParseException {
        PostfixMathCommandI pfmc = node.getPFMC();
        MatrixNodeI[] children = this.visitChildrenAsArray((Node)node, data);
        if (pfmc instanceof BinaryOperatorI) {
            if (node.jjtGetNumChildren() != 2) {
                throw new ParseException("Operator " + node.getOperator().getName() + " must have two elements, it has " + children.length);
            }
            BinaryOperatorI bin = (BinaryOperatorI)pfmc;
            Dimensions dim = bin.calcDim(children[0].getDim(), children[1].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(node.getOperator(), (Node[])children, dim);
        }
        if (pfmc instanceof UnaryOperatorI) {
            if (children.length != 1) {
                throw new ParseException("Operator " + node.getOperator().getName() + " must have one elements, it has " + children.length);
            }
            UnaryOperatorI uni = (UnaryOperatorI)pfmc;
            Dimensions dim = uni.calcDim(children[0].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(node.getOperator(), (Node[])children, dim);
        }
        if (pfmc instanceof NaryOperatorI) {
            Dimensions[] dims = new Dimensions[children.length];
            int i = 0;
            while (i < children.length) {
                dims[i] = children[i].getDim();
                ++i;
            }
            NaryOperatorI uni = (NaryOperatorI)pfmc;
            Dimensions dim = uni.calcDim(dims);
            return (ASTMFunNode)this.nf.buildOperatorNode(node.getOperator(), (Node[])children, dim);
        }
        Dimensions dim = Dimensions.ONE;
        return (ASTMFunNode)this.nf.buildOperatorNode(node.getOperator(), (Node[])children, dim);
    }
}

