/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;

/*
 * Exception performing whole class analysis ignored.
 */
public class Beta {
    private static final double DEFAULT_EPSILON = 1.0E-14;

    private Beta() {
    }

    public static double regularizedBeta(double x, double a, double b) throws MathException {
        return Beta.regularizedBeta((double)x, (double)a, (double)b, (double)1.0E-14, (int)Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a, double b, double epsilon) throws MathException {
        return Beta.regularizedBeta((double)x, (double)a, (double)b, (double)epsilon, (int)Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a, double b, int maxIterations) throws MathException {
        return Beta.regularizedBeta((double)x, (double)a, (double)b, (double)1.0E-14, (int)maxIterations);
    }

    public static double regularizedBeta(double x, double a, double b, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            ret = Double.NaN;
        } else if (x > (a + 1.0) / (a + b + 2.0)) {
            ret = 1.0 - Beta.regularizedBeta((double)(1.0 - x), (double)b, (double)a, (double)epsilon, (int)maxIterations);
        } else {
            1 fraction = new /* Unavailable Anonymous Inner Class!! */;
            ret = Math.exp(a * Math.log(x) + b * Math.log(1.0 - x) - Math.log(a) - Beta.logBeta((double)a, (double)b, (double)epsilon, (int)maxIterations)) * 1.0 / fraction.evaluate(x, epsilon, maxIterations);
        }
        return ret;
    }

    public static double logBeta(double a, double b) {
        return Beta.logBeta((double)a, (double)b, (double)1.0E-14, (int)Integer.MAX_VALUE);
    }

    public static double logBeta(double a, double b, double epsilon, int maxIterations) {
        double ret = Double.isNaN(a) || Double.isNaN(b) || a <= 0.0 || b <= 0.0 ? Double.NaN : Gamma.logGamma((double)a) + Gamma.logGamma((double)b) - Gamma.logGamma((double)(a + b));
        return ret;
    }
}

