/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.random.EmpiricalDistribution;
import org.apache.commons.math.random.EmpiricalDistributionImpl;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalDistributionImpl
implements Serializable,
EmpiricalDistribution {
    private static final long serialVersionUID = 5729073523949762654L;
    private List<SummaryStatistics> binStats = null;
    private SummaryStatistics sampleStats = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta = 0.0;
    private int binCount = 1000;
    private boolean loaded = false;
    private double[] upperBounds = null;
    private RandomData randomData = new RandomDataImpl();

    public EmpiricalDistributionImpl() {
        this.binStats = new ArrayList();
    }

    public EmpiricalDistributionImpl(int binCount) {
        this.binCount = binCount;
        this.binStats = new ArrayList();
    }

    public void load(double[] in) {
        ArrayDataAdapter da = new ArrayDataAdapter(this, in);
        try {
            da.computeStats();
            this.fillBinStats((Object)in);
        }
        catch (IOException e) {
            throw new MathRuntimeException((Throwable)e);
        }
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StreamDataAdapter da = new StreamDataAdapter(this, in);
            da.computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw MathRuntimeException.createEOFException((String)"URL {0} contains no data", (Object[])new Object[]{url});
            }
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fillBinStats((Object)in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            StreamDataAdapter da = new StreamDataAdapter(this, in);
            da.computeStats();
            in = new BufferedReader(new FileReader(file));
            this.fillBinStats((Object)in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void fillBinStats(Object in) throws IOException {
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / Double.valueOf(this.binCount);
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats = new SummaryStatistics();
            this.binStats.add(i, stats);
        }
        DataAdapterFactory aFactory = new DataAdapterFactory(this, null);
        DataAdapter da = aFactory.getAdapter(in);
        da.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)((SummaryStatistics)this.binStats.get(0)).getN() / (double)this.sampleStats.getN();
        for (int i = 1; i < this.binCount - 1; ++i) {
            this.upperBounds[i] = this.upperBounds[i - 1] + (double)((SummaryStatistics)this.binStats.get(i)).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double value) {
        return Math.min(Math.max((int)Math.ceil((value - this.min) / this.delta) - 1, 0), this.binCount - 1);
    }

    public double getNextValue() throws IllegalStateException {
        if (!this.loaded) {
            throw MathRuntimeException.createIllegalStateException((String)"distribution not loaded", (Object[])new Object[0]);
        }
        double x = Math.random();
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats;
            if (!(x <= this.upperBounds[i]) || (stats = (SummaryStatistics)this.binStats.get(i)).getN() <= 0L) continue;
            if (stats.getStandardDeviation() > 0.0) {
                return this.randomData.nextGaussian(stats.getMean(), stats.getStandardDeviation());
            }
            return stats.getMean();
        }
        throw new MathRuntimeException("no bin selected", new Object[0]);
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        double[] binUpperBounds = new double[this.binCount];
        binUpperBounds[0] = this.min + this.delta;
        for (int i = 1; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = binUpperBounds[i - 1] + this.delta;
        }
        binUpperBounds[this.binCount - 1] = this.max;
        return binUpperBounds;
    }

    public double[] getGeneratorUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    static /* synthetic */ int access$100(EmpiricalDistributionImpl x0, double x1) {
        return x0.findBin(x1);
    }

    static /* synthetic */ List access$200(EmpiricalDistributionImpl x0) {
        return x0.binStats;
    }

    static /* synthetic */ SummaryStatistics access$302(EmpiricalDistributionImpl x0, SummaryStatistics x1) {
        x0.sampleStats = x1;
        return x0.sampleStats;
    }

    static /* synthetic */ SummaryStatistics access$300(EmpiricalDistributionImpl x0) {
        return x0.sampleStats;
    }
}

