/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableMultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.optimization.DifferentiableMultivariateRealOptimizer;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.SimpleScalarValueChecker;

public abstract class AbstractScalarDifferentiableOptimizer
implements DifferentiableMultivariateRealOptimizer {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected RealConvergenceChecker checker;
    protected GoalType goal;
    protected double[] point;
    private int maxIterations;
    private int iterations;
    private int maxEvaluations;
    private int evaluations;
    private int gradientEvaluations;
    private DifferentiableMultivariateRealFunction function;
    private MultivariateVectorialFunction gradient;

    protected AbstractScalarDifferentiableOptimizer() {
        this.setConvergenceChecker((RealConvergenceChecker)new SimpleScalarValueChecker());
        this.setMaxIterations(100);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public int getGradientEvaluations() {
        return this.gradientEvaluations;
    }

    public void setConvergenceChecker(RealConvergenceChecker convergenceChecker) {
        this.checker = convergenceChecker;
    }

    public RealConvergenceChecker getConvergenceChecker() {
        return this.checker;
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException((Throwable)new MaxIterationsExceededException(this.maxIterations));
        }
    }

    protected double[] computeObjectiveGradient(double[] evaluationPoint) throws FunctionEvaluationException {
        ++this.gradientEvaluations;
        return this.gradient.value(evaluationPoint);
    }

    protected double computeObjectiveValue(double[] evaluationPoint) throws FunctionEvaluationException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new FunctionEvaluationException((Throwable)new MaxEvaluationsExceededException(this.maxEvaluations), evaluationPoint);
        }
        return this.function.value(evaluationPoint);
    }

    public RealPointValuePair optimize(DifferentiableMultivariateRealFunction f, GoalType goalType, double[] startPoint) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        this.iterations = 0;
        this.evaluations = 0;
        this.gradientEvaluations = 0;
        this.function = f;
        this.gradient = f.gradient();
        this.goal = goalType;
        this.point = (double[])startPoint.clone();
        return this.doOptimize();
    }

    protected abstract RealPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException;
}

