/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.fitting.CurveFitter;
import org.apache.commons.math.optimization.fitting.ParametricRealFunction;
import org.apache.commons.math.optimization.fitting.PolynomialFitter;

public class PolynomialFitter {
    private final CurveFitter fitter;
    private final int degree;

    public PolynomialFitter(int degree, DifferentiableMultivariateVectorialOptimizer optimizer) {
        this.fitter = new CurveFitter(optimizer);
        this.degree = degree;
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.fitter.addObservedPoint(weight, x, y);
    }

    public PolynomialFunction fit() throws OptimizationException {
        try {
            return new PolynomialFunction(this.fitter.fit((ParametricRealFunction)new ParametricPolynomial(null), new double[this.degree + 1]));
        }
        catch (FunctionEvaluationException fee) {
            throw MathRuntimeException.createInternalError((Throwable)fee);
        }
    }
}

