/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.ZipfDistribution;

public class ZipfDistributionImpl
extends AbstractIntegerDistribution
implements ZipfDistribution,
Serializable {
    private static final long serialVersionUID = -140627372283420404L;
    private int numberOfElements;
    private double exponent;

    public ZipfDistributionImpl(int numberOfElements, double exponent) throws IllegalArgumentException {
        this.setNumberOfElementsInternal(numberOfElements);
        this.setExponentInternal(exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Deprecated
    public void setNumberOfElements(int n) {
        this.setNumberOfElementsInternal(n);
    }

    private void setNumberOfElementsInternal(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid number of elements {0} (must be positive)", (Object[])new Object[]{n});
        }
        this.numberOfElements = n;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Deprecated
    public void setExponent(double s) {
        this.setExponentInternal(s);
    }

    private void setExponentInternal(double s) throws IllegalArgumentException {
        if (s <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid exponent {0} (must be positive)", (Object[])new Object[]{s});
        }
        this.exponent = s;
    }

    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(x, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(x, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    protected int getDomainLowerBound(double p) {
        return 0;
    }

    protected int getDomainUpperBound(double p) {
        return this.numberOfElements;
    }

    private double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k > 0; --k) {
            value += 1.0 / Math.pow(k, m);
        }
        return value;
    }
}

