/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.WeibullDistribution;

public class WeibullDistributionImpl
extends AbstractContinuousDistribution
implements WeibullDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double shape;
    private double scale;
    private final double solverAbsoluteAccuracy;

    public WeibullDistributionImpl(double alpha, double beta) {
        this(alpha, beta, 1.0E-9);
    }

    public WeibullDistributionImpl(double alpha, double beta, double inverseCumAccuracy) {
        this.setShapeInternal(alpha);
        this.setScaleInternal(beta);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
        return ret;
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double xscale = x / this.scale;
        double xscalepow = Math.pow(xscale, this.shape - 1.0);
        double xscalepowshape = xscalepow * xscale;
        return this.shape / this.scale * xscalepow * Math.exp(-xscalepowshape);
    }

    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} out of [{1}, {2}] range", (Object[])new Object[]{p, 0.0, 1.0});
        }
        double ret = p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : this.scale * Math.pow(-Math.log(1.0 - p), 1.0 / this.shape));
        return ret;
    }

    @Deprecated
    public void setShape(double alpha) {
        this.setShapeInternal(alpha);
    }

    private void setShapeInternal(double alpha) {
        if (alpha <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"shape must be positive ({0})", (Object[])new Object[]{alpha});
        }
        this.shape = alpha;
    }

    @Deprecated
    public void setScale(double beta) {
        this.setScaleInternal(beta);
    }

    private void setScaleInternal(double beta) {
        if (beta <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"scale must be positive ({0})", (Object[])new Object[]{beta});
        }
        this.scale = beta;
    }

    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        return Math.pow(this.scale * Math.log(2.0), 1.0 / this.shape);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

