/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.MicrosphereInterpolatingFunction;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.random.UnitSphereRandomVectorGenerator;

public class MicrosphereInterpolatingFunction
implements MultivariateRealFunction {
    private final int dimension;
    private final List<MicrosphereSurfaceElement> microsphere;
    private final double brightnessExponent;
    private final Map<RealVector, Double> samples;

    public MicrosphereInterpolatingFunction(double[][] xval, double[] yval, int brightnessExponent, int microsphereElements, UnitSphereRandomVectorGenerator rand) throws DimensionMismatchException, IllegalArgumentException {
        int i;
        if (xval.length == 0 || xval[0] == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"no data", (Object[])new Object[0]);
        }
        if (xval.length != yval.length) {
            throw new DimensionMismatchException(xval.length, yval.length);
        }
        this.dimension = xval[0].length;
        this.brightnessExponent = brightnessExponent;
        this.samples = new HashMap(yval.length);
        for (i = 0; i < xval.length; ++i) {
            double[] xvalI = xval[i];
            if (xvalI.length != this.dimension) {
                throw new DimensionMismatchException(xvalI.length, this.dimension);
            }
            this.samples.put(new ArrayRealVector(xvalI), yval[i]);
        }
        this.microsphere = new ArrayList(microsphereElements);
        for (i = 0; i < microsphereElements; ++i) {
            this.microsphere.add(new MicrosphereSurfaceElement(rand.nextVector()));
        }
    }

    public double value(double[] point) {
        ArrayRealVector p = new ArrayRealVector(point);
        for (MicrosphereSurfaceElement microsphereSurfaceElement : this.microsphere) {
            microsphereSurfaceElement.reset();
        }
        for (Map.Entry entry : this.samples.entrySet()) {
            RealVector diff = ((RealVector)entry.getKey()).subtract((RealVector)p);
            double diffNorm = diff.getNorm();
            if (Math.abs(diffNorm) < Math.ulp(1.0)) {
                return (Double)entry.getValue();
            }
            for (MicrosphereSurfaceElement md : this.microsphere) {
                double w = Math.pow(diffNorm, -this.brightnessExponent);
                md.store(this.cosAngle(diff, md.normal()) * w, entry);
            }
        }
        double value = 0.0;
        double totalWeight = 0.0;
        for (MicrosphereSurfaceElement md : this.microsphere) {
            double iV = md.illumination();
            Map.Entry sd = md.sample();
            if (sd == null) continue;
            value += iV * (Double)sd.getValue();
            totalWeight += iV;
        }
        return value / totalWeight;
    }

    private double cosAngle(RealVector v, RealVector w) {
        return v.dotProduct(w) / (v.getNorm() * w.getNorm());
    }
}

