/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineFunction;
import org.apache.commons.math.util.MathUtils;

public class BicubicSplineInterpolatingFunction
implements BivariateRealFunction {
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicSplineFunction[][] splines;

    public BicubicSplineInterpolatingFunction(double[] x, double[] y, double[][] z, double[][] dZdX, double[][] dZdY, double[][] dZdXdY) throws DimensionMismatchException {
        int xLen = x.length;
        int yLen = y.length;
        if (xLen == 0 || yLen == 0 || z.length == 0 || z[0].length == 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"no data", (Object[])new Object[0]);
        }
        if (xLen != z.length) {
            throw new DimensionMismatchException(xLen, z.length);
        }
        if (xLen != dZdX.length) {
            throw new DimensionMismatchException(xLen, dZdX.length);
        }
        if (xLen != dZdY.length) {
            throw new DimensionMismatchException(xLen, dZdY.length);
        }
        if (xLen != dZdXdY.length) {
            throw new DimensionMismatchException(xLen, dZdXdY.length);
        }
        MathUtils.checkOrder((double[])x, (int)1, (boolean)true);
        MathUtils.checkOrder((double[])y, (int)1, (boolean)true);
        this.xval = (double[])x.clone();
        this.yval = (double[])y.clone();
        int lastI = xLen - 1;
        int lastJ = yLen - 1;
        this.splines = new BicubicSplineFunction[lastI][lastJ];
        for (int i = 0; i < lastI; ++i) {
            if (z[i].length != yLen) {
                throw new DimensionMismatchException(z[i].length, yLen);
            }
            if (dZdX[i].length != yLen) {
                throw new DimensionMismatchException(dZdX[i].length, yLen);
            }
            if (dZdY[i].length != yLen) {
                throw new DimensionMismatchException(dZdY[i].length, yLen);
            }
            if (dZdXdY[i].length != yLen) {
                throw new DimensionMismatchException(dZdXdY[i].length, yLen);
            }
            int ip1 = i + 1;
            for (int j = 0; j < lastJ; ++j) {
                int jp1 = j + 1;
                double[] beta = new double[]{z[i][j], z[ip1][j], z[i][jp1], z[ip1][jp1], dZdX[i][j], dZdX[ip1][j], dZdX[i][jp1], dZdX[ip1][jp1], dZdY[i][j], dZdY[ip1][j], dZdY[i][jp1], dZdY[ip1][jp1], dZdXdY[i][j], dZdXdY[ip1][j], dZdXdY[i][jp1], dZdXdY[ip1][jp1]};
                this.splines[i][j] = new BicubicSplineFunction(this.computeSplineCoefficients(beta));
            }
        }
    }

    public double value(double x, double y) {
        int i = this.searchIndex(x, this.xval);
        if (i == -1) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} out of [{1}, {2}] range", (Object[])new Object[]{x, this.xval[0], this.xval[this.xval.length - 1]});
        }
        int j = this.searchIndex(y, this.yval);
        if (j == -1) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} out of [{1}, {2}] range", (Object[])new Object[]{y, this.yval[0], this.yval[this.yval.length - 1]});
        }
        double xN = (x - this.xval[i]) / (this.xval[i + 1] - this.xval[i]);
        double yN = (y - this.yval[j]) / (this.yval[j + 1] - this.yval[j]);
        return this.splines[i][j].value(xN, yN);
    }

    private int searchIndex(double c, double[] val) {
        if (c < val[0]) {
            return -1;
        }
        int max = val.length;
        for (int i = 1; i < max; ++i) {
            if (!(c <= val[i])) continue;
            return i - 1;
        }
        return -1;
    }

    private double[] computeSplineCoefficients(double[] beta) {
        double[] a = new double[16];
        for (int i = 0; i < 16; ++i) {
            double result = 0.0;
            double[] row = AINV[i];
            for (int j = 0; j < 16; ++j) {
                result += row[j] * beta[j];
            }
            a[i] = result;
        }
        return a;
    }
}

