/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.test;

import eu.qimpress.ide.analysis.reliability.rmc.core.Module;
import eu.qimpress.ide.analysis.reliability.rmc.core.ModuleInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.Node;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeNotFoundException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeType;
import eu.qimpress.ide.analysis.reliability.rmc.core.ProbabilityException;
import eu.qimpress.ide.analysis.reliability.rmc.core.RMC;
import eu.qimpress.ide.analysis.reliability.rmc.mat.BasicSolver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.NewtonSolver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;
import org.nfunk.jep.ParseException;

public class HandForged {
    public static void main(String[] args) {
        try {
            RMC r1 = new RMC("R1");
            Module m1 = new Module("m1");
            Node start1 = new Node("S1", NodeType.START, null);
            Node op11 = new Node("O11", NodeType.NORMAL, null);
            Node op12 = new Node("O12", NodeType.NORMAL, null);
            Node fail1 = new Node("F1", NodeType.FAILURE, null);
            Node end1 = new Node("E1", NodeType.END, null);
            m1.addNode(start1);
            m1.addNode(op11);
            m1.addNode(op12);
            m1.addNode(fail1);
            m1.addNode(end1);
            m1.addTransition(start1, op11, 1.0);
            m1.addTransition(op11, op12, 0.99);
            m1.addTransition(op11, fail1, 0.01);
            m1.addTransition(op12, end1, 0.95);
            m1.addTransition(op12, fail1, 0.05);
            r1.addModule(m1, true);
            r1.computeEquations();
            System.out.println("RMC  validation : " + r1.validate());
            System.out.println("Equations: {");
            for (String s : r1.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            RMC r2 = new RMC("R2");
            Module m2 = new Module("m2");
            Node start2 = new Node("S2", NodeType.START, null);
            Node op21 = new Node("O21", NodeType.NORMAL, null);
            Node op22 = new Node("O22", NodeType.NORMAL, null);
            Node fail2 = new Node("F2", NodeType.FAILURE, null);
            Node end2 = new Node("E2", NodeType.END, null);
            m2.addNode(start2);
            m2.addNode(op21);
            m2.addNode(op22);
            m2.addNode(fail2);
            m2.addNode(end2);
            m2.addTransition(start2, op21, 1.0);
            m2.addTransition(op21, op22, 0.49);
            m2.addTransition(op21, op21, 0.5);
            m2.addTransition(op21, fail2, 0.01);
            m2.addTransition(op22, end2, 0.95);
            m2.addTransition(op22, fail2, 0.05);
            r2.addModule(m2, true);
            r2.computeEquations();
            System.out.println("RMC validation : " + r2.validate());
            System.out.println("Equations: {");
            for (String s : r2.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            RMC r3 = new RMC("R3");
            Module m3 = new Module("m3");
            Node start3 = new Node("S3", NodeType.START, null);
            Node op31 = new Node("O31", NodeType.NORMAL, null);
            Node op32 = new Node("O32", NodeType.NORMAL, null);
            Node fail3 = new Node("F3", NodeType.FAILURE, null);
            Node end3 = new Node("E3", NodeType.END, null);
            m3.addNode(start3);
            m3.addNode(op31);
            m3.addNode(op32);
            m3.addNode(fail3);
            m3.addNode(end3);
            m3.addTransition(start3, op31, 1.0);
            m3.addTransition(op31, op32, 0.99);
            m3.addTransition(op31, fail3, 0.01);
            m3.addTransition(op32, end3, 0.95);
            m3.addTransition(op32, fail3, 0.05);
            r3.addModule(m3, false);
            Module m4 = new Module("m4");
            Node start4 = new Node("S4", NodeType.START, null);
            Node op41 = new Node("O41", NodeType.NORMAL, null);
            Node c41 = new Node("C41", NodeType.CALL, m3);
            Node fail4 = new Node("F4", NodeType.FAILURE, null);
            Node end4 = new Node("E4", NodeType.END, null);
            m4.addNode(start4);
            m4.addNode(op41);
            m4.addNode(c41);
            m4.addNode(fail4);
            m4.addNode(end4);
            m4.addTransition(start4, op41, 1.0);
            m4.addTransition(op41, c41, 0.99);
            m4.addTransition(op41, fail4, 0.01);
            m4.addTransition(c41, end4, 0.95);
            m4.addTransition(c41, fail4, 0.05);
            r3.addModule(m4, true);
            r3.computeEquations();
            System.out.println("RMC validation : " + r3.validate());
            System.out.println("Equations: {");
            for (String s : r3.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            RMC r4 = new RMC("R4");
            Module m5 = new Module("m5");
            Module m6 = new Module("m6");
            Node start5 = new Node("S5", NodeType.START, null);
            Node op51 = new Node("O51", NodeType.NORMAL, null);
            Node c51 = new Node("C51", NodeType.CALL, m6);
            Node fail5 = new Node("F5", NodeType.FAILURE, null);
            Node end5 = new Node("E5", NodeType.END, null);
            m5.addNode(start5);
            m5.addNode(op51);
            m5.addNode(c51);
            m5.addNode(fail5);
            m5.addNode(end5);
            m5.addTransition(start5, op51, 1.0);
            m5.addTransition(op51, c51, 0.99);
            m5.addTransition(op51, fail5, 0.01);
            m5.addTransition(c51, end5, 1.0);
            r4.addModule(m5, false);
            Node start6 = new Node("S6", NodeType.START, null);
            Node op61 = new Node("O61", NodeType.NORMAL, null);
            Node c61 = new Node("C61", NodeType.CALL, m5);
            Node fail6 = new Node("F6", NodeType.FAILURE, null);
            Node end6 = new Node("E6", NodeType.END, null);
            m6.addNode(start6);
            m6.addNode(op61);
            m6.addNode(c61);
            m6.addNode(fail6);
            m6.addNode(end6);
            m6.addTransition(start6, op61, 1.0);
            m6.addTransition(op61, c61, 0.49);
            m6.addTransition(op61, end6, 0.5);
            m6.addTransition(op61, fail6, 0.01);
            m6.addTransition(c61, end6, 1.0);
            r4.addModule(m6, true);
            r4.computeEquations();
            System.out.println("RMC validation : " + r4.validate());
            System.out.println("Equations: {");
            for (String s : r4.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            RMC fig4 = new RMC("FIG4");
            Module m7 = new Module("m7");
            Node start7 = new Node("S7", NodeType.START, null);
            Node c71 = new Node("C71", NodeType.CALL, m7);
            Node c72 = new Node("C72", NodeType.CALL, m7);
            Node end7 = new Node("E7", NodeType.END, null);
            m7.addNode(start7);
            m7.addNode(c71);
            m7.addNode(c72);
            m7.addNode(end7);
            m7.addTransition(start7, c71, 0.5);
            m7.addTransition(start7, end7, 0.5);
            m7.addTransition(c71, c72, 1.0);
            m7.addTransition(c72, end7, 1.0);
            fig4.addModule(m7, true);
            fig4.computeEquations();
            r4.computeEquations();
            System.out.println("RMC validation : " + fig4.validate());
            System.out.println("Equations: {");
            for (String s : fig4.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            RMC analyze = fig4;
            System.out.println("NEWTON Solver");
            NewtonSolver ns = new NewtonSolver(analyze.getEquations());
            ns.printCurrentAssign();
            ns.iterateUntilTargetAVG10DeltalessThan(String.valueOf(analyze.getInitialModule().getName()) + analyze.getInitialModule().getStart().getName(), Math.pow(10.0, -12.0), 1000000L);
            ns.printCurrentAssign();
            System.out.println("Reliability: " + ns.getValue(String.valueOf(analyze.getInitialModule().getName()) + analyze.getInitialModule().getStart().getName()));
            System.out.println("MSV: " + ns.getMSV());
            System.out.println("Iterations: " + ns.getNumIterations());
            System.out.println("BASIC Solver");
            BasicSolver bs = new BasicSolver(analyze.getEquations());
            bs.printCurrentAssign();
            int bitOfPrecision = 20;
            bs.iterateUntilMSVlessThan(0.0, (long)Math.pow(2.0, bitOfPrecision));
            bs.printCurrentAssign();
            System.out.println("Reliability: " + bs.getValue(String.valueOf(analyze.getInitialModule().getName()) + analyze.getInitialModule().getStart().getName()));
            System.out.println("MSV: " + bs.getMSV());
            System.out.println("Iterations: " + bs.getNumIterations());
        }
        catch (NodeInstantiationException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (ModuleInstantiationException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (NodeNotFoundException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (ProbabilityException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (TargetVariableNotFoundException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

