/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.mat;

import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.math.linear.BigMatrixImpl;
import org.lsmp.djep.djep.DJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class NewtonSolver
implements Solver {
    public static final int INTERMEDIATE_OPERATIONS_SCALE = 50;
    private String[] vars;
    private String[] functs;
    private double[] currAssign;
    private long numIterations = 0L;
    private double msv = 0.0;

    public NewtonSolver(Set<String> equations) {
        this.vars = new String[equations.size()];
        this.functs = new String[equations.size()];
        this.currAssign = new double[equations.size()];
        int count = 0;
        for (String eq : equations) {
            String var;
            this.vars[count] = var = eq.replaceAll(" ", "").substring(0, eq.indexOf("="));
            try {
                double val;
                this.currAssign[count] = val = Double.parseDouble(eq.replaceAll(" ", "").substring(eq.indexOf("=") + 1));
                this.functs[count] = "" + val;
            }
            catch (NumberFormatException numberFormatException) {
                this.currAssign[count] = 0.0;
                this.functs[count] = eq.replaceAll(" ", "").substring(eq.indexOf("=") + 1);
            }
            ++count;
        }
        this.numIterations = 0L;
        this.msv = 0.0;
    }

    @Override
    public long getNumIterations() {
        return this.numIterations;
    }

    @Override
    public double getValue(String var) throws TargetVariableNotFoundException {
        int i = 0;
        while (i < this.vars.length) {
            if (this.vars[i].equals(var)) {
                return this.currAssign[i];
            }
            ++i;
        }
        throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
    }

    public void NewtonIterate() throws ParseException {
        double[] F = new double[this.vars.length];
        double[][] F1 = new double[this.vars.length][this.vars.length];
        DJep parser = new DJep();
        parser.addStandardConstants();
        parser.addStandardFunctions();
        parser.addComplex();
        parser.setAllowUndeclared(true);
        parser.setAllowAssignment(true);
        parser.setImplicitMul(true);
        parser.addStandardDiffRules();
        int i = 0;
        while (i < this.vars.length) {
            parser.addVariable(this.vars[i], this.currAssign[i]);
            ++i;
        }
        i = 0;
        while (i < F.length) {
            parser.parseExpression(this.functs[i]);
            double f = parser.getValue();
            F[i] = f - this.currAssign[i];
            int j = 0;
            while (j < F.length) {
                Node n1 = parser.parse("diff(" + this.functs[i] + "-" + this.vars[i] + "," + this.vars[j] + ")");
                Node processed = parser.preprocess(n1);
                Node simpl = parser.simplify(processed);
                Object o = parser.evaluate(simpl);
                F1[i][j] = f = ((Double)o).doubleValue();
                ++j;
            }
            ++i;
        }
        BigMatrixImpl F1m = new BigMatrixImpl(F1);
        F1m.setScale(50);
        double[][] F1i = F1m.inverse().getDataAsDoubleArray();
        double[] diff = new double[this.vars.length];
        this.msv = 0.0;
        int i2 = 0;
        while (i2 < diff.length) {
            diff[i2] = 0.0;
            int j = 0;
            while (j < F1i[i2].length) {
                int n = i2;
                diff[n] = diff[n] + F1i[i2][j] * F[j];
                ++j;
            }
            this.msv += Math.pow(diff[i2], 2.0);
            int n = i2;
            this.currAssign[n] = this.currAssign[n] - diff[i2];
            ++i2;
        }
        ++this.numIterations;
        this.msv = Math.sqrt(this.msv);
    }

    @Override
    public void printCurrentAssign() {
        System.out.println("Iterations so far: " + this.numIterations);
        int i = 0;
        while (i < this.vars.length) {
            System.out.println(String.valueOf(this.vars[i]) + "\t = " + this.currAssign[i]);
            ++i;
        }
    }

    @Override
    public void doNIterations(long n) throws ParseException {
        long i = 0L;
        while (i < n) {
            this.NewtonIterate();
            ++i;
        }
    }

    @Override
    public HashMap<String, Double> getCurrentAssignment() {
        HashMap<String, Double> ret = new HashMap<String, Double>(this.vars.length);
        int i = 0;
        while (i < this.vars.length) {
            ret.put(String.valueOf(this.vars[i]), this.currAssign[i]);
            ++i;
        }
        return ret;
    }

    @Override
    public double getMSV() {
        return this.msv;
    }

    @Override
    public void iterateUntilMSVlessThan(double maxMSV, long maxIterations) throws ParseException {
        long i = 0L;
        while (i < maxIterations) {
            if (this.numIterations > 0L && this.msv <= maxMSV) break;
            this.NewtonIterate();
            ++i;
        }
    }

    @Override
    public void iterateUntilTargetDeltalessThan(String var, double maxVariation, long maxIterations) throws TargetVariableNotFoundException, ParseException {
        boolean found = false;
        int i = 0;
        i = 0;
        while (i < this.vars.length) {
            if (this.vars[i].equals(var)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
        }
        double pastValue = this.currAssign[i];
        long j = 0L;
        while (j < maxIterations) {
            this.NewtonIterate();
            if (Math.abs(this.currAssign[i] - pastValue) <= maxVariation) break;
            pastValue = this.currAssign[i];
            ++j;
        }
    }

    @Override
    public void iterateUntilTargetAVG10DeltalessThan(String var, double maxVariation, long maxIterations) throws Exception {
        boolean found = false;
        int i = 0;
        i = 0;
        while (i < this.vars.length) {
            if (this.vars[i].equals(var)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
        }
        double[] pastValues = new double[10];
        int window = 0;
        pastValues[window % 10] = this.currAssign[i];
        ++window;
        long j = 0L;
        while (j < maxIterations) {
            this.NewtonIterate();
            pastValues[window % 10] = this.currAssign[i];
            ++window;
            double avg = 0.0;
            int k = 0;
            while (k < 9 && (long)k <= this.numIterations) {
                avg += Math.abs(pastValues[k] - pastValues[k + 1]);
                ++k;
            }
            if ((avg /= (double)Math.max(Math.min(9L, this.numIterations), 1L)) <= maxVariation) break;
            ++j;
        }
    }

    @Override
    public void setCurrentAssignment(HashMap<String, Double> assigns) throws TargetVariableNotFoundException {
        if (assigns == null || assigns.size() != this.vars.length) {
            throw new TargetVariableNotFoundException("Variables set not compatible.");
        }
        int i = 0;
        while (i < this.vars.length) {
            if (!assigns.containsKey(this.vars[i])) {
                throw new TargetVariableNotFoundException("Variable " + this.vars[i] + " not assigned.");
            }
            this.currAssign[i] = assigns.get(this.vars[i]);
            ++i;
        }
    }
}

