/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.mat;

import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import org.nfunk.jep.JEP;

public class BasicSolver
implements Solver {
    private Set<String> equations;
    private HashMap<String, Double> currentAssign;
    private long numIterations = 0L;
    private double msv = 0.0;

    public BasicSolver(Set<String> equations) {
        this.equations = equations;
        this.initialAssign();
    }

    private void initialAssign() {
        new Random(System.nanoTime());
        this.currentAssign = new HashMap(this.equations.size());
        for (String eq : this.equations) {
            double val;
            String var = eq.replaceAll(" ", "").substring(0, eq.indexOf("="));
            if (this.currentAssign.containsKey(var)) continue;
            try {
                val = Double.parseDouble(eq.replaceAll(" ", "").substring(eq.indexOf("=") + 1));
                this.currentAssign.put(var, val);
            }
            catch (NumberFormatException numberFormatException) {
                val = 0.0;
                this.currentAssign.put(var, val);
            }
        }
        this.numIterations = 0L;
        this.msv = 0.0;
    }

    @Override
    public long getNumIterations() {
        return this.numIterations;
    }

    @Override
    public void printCurrentAssign() {
        if (this.currentAssign == null || this.currentAssign.isEmpty()) {
            System.out.println("No valid assignment present.");
        } else {
            System.out.println("Iterations so far: " + this.numIterations);
            for (String s : this.currentAssign.keySet()) {
                System.out.println(String.valueOf(s) + "\t = " + this.currentAssign.get(s));
            }
        }
    }

    @Override
    public HashMap<String, Double> getCurrentAssignment() {
        return this.currentAssign;
    }

    @Override
    public void iterateUntilMSVlessThan(double maxMSV, long maxIterations) {
        long i = 0L;
        while (i < maxIterations) {
            if (this.numIterations > 0L && this.msv <= maxMSV) break;
            this.basicIterate();
            ++i;
        }
    }

    @Override
    public double getValue(String var) throws TargetVariableNotFoundException {
        if (this.currentAssign == null || !this.currentAssign.containsKey(var)) {
            throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
        }
        return this.currentAssign.get(var);
    }

    @Override
    public void iterateUntilTargetDeltalessThan(String var, double maxVariation, long maxIterations) throws TargetVariableNotFoundException {
        if (this.currentAssign == null || !this.currentAssign.containsKey(var)) {
            throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
        }
        double pastValue = this.currentAssign.get(var);
        long i = 0L;
        while (i < maxIterations) {
            this.basicIterate();
            if (Math.abs(this.currentAssign.get(var) - pastValue) <= maxVariation) break;
            pastValue = this.currentAssign.get(var);
            ++i;
        }
    }

    @Override
    public void doNIterations(long num) {
        long i = 0L;
        while (i < num) {
            this.basicIterate();
            ++i;
        }
    }

    @Override
    public double getMSV() {
        return this.msv;
    }

    private void basicIterate() {
        JEP parser = new JEP();
        this.msv = 0.0;
        for (String v : this.currentAssign.keySet()) {
            parser.addVariable(v, (Object)this.currentAssign.get(v));
        }
        for (String eq : this.equations) {
            String var = eq.replaceAll(" ", "").substring(0, eq.indexOf("="));
            if (!this.currentAssign.containsKey(var)) {
                System.err.println("Wrong assignment disctioanry initialization. Missing variable: " + var);
            }
            try {
                double val = Double.parseDouble(eq.replaceAll(" ", "").substring(eq.indexOf("=") + 1));
                this.msv += Math.pow(this.currentAssign.get(var) - val, 2.0);
                this.currentAssign.put(var, val);
            }
            catch (NumberFormatException numberFormatException) {
                String expression = eq.replaceAll(" ", "").substring(eq.indexOf("=") + 1);
                parser.parseExpression(expression);
                double val = parser.getValue();
                this.msv += Math.pow(this.currentAssign.get(var) - val, 2.0);
                this.currentAssign.put(var, val);
            }
        }
        ++this.numIterations;
        this.msv = Math.sqrt(this.msv);
    }

    @Override
    public void iterateUntilTargetAVG10DeltalessThan(String var, double maxVariation, long maxIterations) throws Exception {
        if (this.currentAssign == null || !this.currentAssign.containsKey(var)) {
            throw new TargetVariableNotFoundException("Variable " + var + " not in current valid assignment");
        }
        double[] pastValues = new double[10];
        int window = 0;
        pastValues[window % 10] = this.currentAssign.get(var);
        ++window;
        long i = 0L;
        while (i < maxIterations) {
            this.basicIterate();
            pastValues[window % 10] = this.currentAssign.get(var);
            ++window;
            double avg = 0.0;
            int k = 0;
            while (k < 9 && (long)k <= this.numIterations) {
                avg += Math.abs(pastValues[k] - pastValues[k + 1]);
                ++k;
            }
            if ((avg /= (double)Math.max(Math.min(9L, this.numIterations), 1L)) <= maxVariation) break;
            ++i;
        }
    }

    @Override
    public void setCurrentAssignment(HashMap<String, Double> assigns) throws Exception {
        if (assigns == null || assigns.size() != this.currentAssign.size()) {
            throw new TargetVariableNotFoundException("Variables set not compatible.");
        }
        HashMap temp = (HashMap)assigns.clone();
        temp.keySet().removeAll(this.currentAssign.keySet());
        if (temp.size() != 0) {
            throw new TargetVariableNotFoundException("Variables set not compatible.");
        }
        this.currentAssign = assigns;
    }
}

