/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import eu.qimpress.ide.analysis.reliability.rmc.core.Module;
import eu.qimpress.ide.analysis.reliability.rmc.core.ModuleInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.Node;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeNotFoundException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeType;
import eu.qimpress.ide.analysis.reliability.rmc.core.ProbabilityException;
import eu.qimpress.ide.analysis.reliability.rmc.core.RMC;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcModel;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcModule;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcNode;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcTransition;
import eu.qimpress.ide.analysis.reliability.rmc.mat.Calculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Transfomation {
    public HashMap<IDtmcModule, Module> modules = new HashMap();
    public HashMap<IDtmcNode, Node> nodes = new HashMap();

    public RMC generateRMC(IDtmcModel dtmcModel) throws NodeInstantiationException, NumberFormatException, NodeNotFoundException, ProbabilityException, ModuleInstantiationException {
        RMC rmc = new RMC(dtmcModel.getName());
        for (IDtmcModule dtmcModule : dtmcModel.getModules()) {
            this.modules.put(dtmcModule, this.createModule(dtmcModule));
        }
        for (IDtmcModule dtmcModule : dtmcModel.getModules()) {
            this.mapModule(rmc, dtmcModule, this.modules.get(dtmcModule));
        }
        return rmc;
    }

    public void mapModule(RMC rmc, IDtmcModule dtmcModule, Module module) throws NodeInstantiationException, NumberFormatException, NodeNotFoundException, ProbabilityException, ModuleInstantiationException {
        for (IDtmcNode dtmcNode : dtmcModule.getNodes()) {
            Node node = this.createNode(dtmcNode);
            this.nodes.put(dtmcNode, node);
            module.addNode(node);
        }
        for (IDtmcTransition transition : dtmcModule.getTransitions()) {
            double probability;
            if (transition.get_from() == null || transition.get_to() == null || transition.getProbability().contentEquals("0") || transition.getProbability().contentEquals("0.0") || (probability = new Calculator().result(transition.getProbability())) <= 0.0) continue;
            module.addTransition(this.nodes.get(transition.get_from()), this.nodes.get(transition.get_to()), probability);
        }
        rmc.addModule(module, dtmcModule.isAutonomous());
    }

    public Node createNode(IDtmcNode dtmcNode) throws NodeInstantiationException {
        List<NodeFactory> factories = this.getNodeFactories();
        for (NodeFactory factory : factories) {
            if (!factory.testPrecoditions(dtmcNode)) continue;
            return factory.createNode(dtmcNode);
        }
        throw new NodeInstantiationException("Invalid node type. Doesn't exist a factory for this dtmcNode.");
    }

    private List<NodeFactory> getNodeFactories() {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        factories.add(new StartNodeFactory());
        factories.add(new EndNodeFactory());
        factories.add(new FailNodeFactory());
        factories.add(new CallNodeFactory());
        factories.add(new NormalNodeFactory());
        return factories;
    }

    private Module createModule(IDtmcModule module) {
        return new Module(module.getName());
    }

    class CallNodeFactory
    implements NodeFactory {
        CallNodeFactory() {
        }

        @Override
        public Node createNode(IDtmcNode node) throws NodeInstantiationException {
            return new Node(node.getName(), NodeType.CALL, Transfomation.this.modules.get(node.getOutTransitions().get(0).getCalleeModule()));
        }

        @Override
        public boolean testPrecoditions(IDtmcNode node) {
            if (node.getOutTransitions() == null || node.getOutTransitions().size() < 1) {
                return false;
            }
            return node.getOutTransitions().get(0).callModule();
        }
    }

    class EndNodeFactory
    implements NodeFactory {
        EndNodeFactory() {
        }

        @Override
        public Node createNode(IDtmcNode node) throws NodeInstantiationException {
            return new Node(node.getName(), NodeType.END, null);
        }

        @Override
        public boolean testPrecoditions(IDtmcNode node) {
            return node.isEndNode();
        }
    }

    class FailNodeFactory
    implements NodeFactory {
        FailNodeFactory() {
        }

        @Override
        public Node createNode(IDtmcNode node) throws NodeInstantiationException {
            return new Node(node.getName(), NodeType.FAILURE, null);
        }

        @Override
        public boolean testPrecoditions(IDtmcNode node) {
            return node.isFailNode();
        }
    }

    static interface NodeFactory {
        public boolean testPrecoditions(IDtmcNode var1);

        public Node createNode(IDtmcNode var1) throws NodeInstantiationException;
    }

    class NormalNodeFactory
    implements NodeFactory {
        NormalNodeFactory() {
        }

        @Override
        public Node createNode(IDtmcNode node) throws NodeInstantiationException {
            return new Node(node.getName(), NodeType.NORMAL, null);
        }

        @Override
        public boolean testPrecoditions(IDtmcNode node) {
            return true;
        }
    }

    class StartNodeFactory
    implements NodeFactory {
        StartNodeFactory() {
        }

        @Override
        public Node createNode(IDtmcNode node) throws NodeInstantiationException {
            return new Node(node.getName(), NodeType.START, null);
        }

        @Override
        public boolean testPrecoditions(IDtmcNode node) {
            return node.isStartNode();
        }
    }
}

