/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import eu.qimpress.dtmc.Node;
import eu.qimpress.dtmc.Transition;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcNode;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcTransition;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.ModelMap;
import java.util.ArrayList;
import java.util.List;

public class DtmcNode
implements IDtmcNode {
    private Node node;
    private ModelMap map;
    private List<IDtmcTransition> outTransitions;
    private ArrayList<IDtmcTransition> inTransitions;

    public DtmcNode(ModelMap map, Node node) {
        this.map = map;
        this.node = node;
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public List<IDtmcTransition> getInTransitions() {
        if (this.inTransitions == null) {
            this.initInTransitions();
        }
        return this.inTransitions;
    }

    @Override
    public List<IDtmcTransition> getOutTransitions() {
        if (this.outTransitions == null) {
            this.initOutTransitions();
        }
        return this.outTransitions;
    }

    private void initInTransitions() {
        this.inTransitions = new ArrayList();
        if (this.node.getInTransitions() != null) {
            for (Transition transition : this.node.getInTransitions()) {
                this.inTransitions.add(this.map.dtmcTransition(transition));
            }
        }
    }

    private void initOutTransitions() {
        this.outTransitions = new ArrayList<IDtmcTransition>();
        if (this.node.getOutTransitions() != null) {
            for (Transition transition : this.node.getOutTransitions()) {
                this.outTransitions.add(this.map.dtmcTransition(transition));
            }
        }
    }

    @Override
    public boolean isEndNode() {
        return this.node.isIsEnd();
    }

    @Override
    public boolean isFailNode() {
        return this.node.isIsFail();
    }

    @Override
    public boolean isStartNode() {
        return this.node.isIsStart();
    }
}

