/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.launch;

import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysis;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ReliabilityLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Analysis parameters";
    private Text resultPrecisionDigit;

    public void createControl(Composite parent) {
        Composite topControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        topControl.setLayout((Layout)layout);
        this.setControl((Control)topControl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label precision = new Label(topControl, 0);
        precision.setText("Number of decimal digit precision");
        this.resultPrecisionDigit = new Text(topControl, 0);
        this.resultPrecisionDigit.setLayoutData((Object)gd);
        this.resultPrecisionDigit.setEditable(true);
    }

    public String getName() {
        return TAB_NAME;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.resultPrecisionDigit.setText(configuration.getAttribute("RESULT_PRECISION", this.defaultReliabilityResultPrecision()));
        }
        catch (CoreException e) {
            ErrorDialog d = new ErrorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Configuration Error", "Error while configuring launch.", (IStatus)new Status(4, "eu.qimpress.ide.reliability", e.getMessage(), (Throwable)e), 0);
            d.open();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("RESULT_PRECISION", this.resultPrecisionDigit.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("RESULT_PRECISION", this.defaultReliabilityResultPrecision());
    }

    private String defaultReliabilityResultPrecision() {
        return new Integer(ReliabilityAnalysis.DEFAULT_RESULT_PRECISION).toString();
    }
}

