/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.dtmc.Dtmc;
import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysisResult;
import eu.qimpress.ide.analysis.reliability.rmc.core.RMC;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.DtmcModel;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.ResourceHelper;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.Transfomation;
import eu.qimpress.ide.analysis.reliability.rmc.mat.BasicSolver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class ReliabilityAnalysis
implements IJob {
    public static int DEFAULT_RESULT_PRECISION = 12;
    URI dtmcModelFile;
    private RMC rmc;
    private Solver ns;
    private int resultDecimalDigitsPrecision;

    public ReliabilityAnalysis(URI dtmcModelFile, int resultDecimalDigitsPrecision) {
        this.dtmcModelFile = dtmcModelFile;
        this.resultDecimalDigitsPrecision = resultDecimalDigitsPrecision;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        DtmcModel dtmcModel;
        long resultPrecisionBase2 = 1L + (long)((double)this.resultDecimalDigitsPrecision * Math.log(10.0) / Math.log(2.0));
        long starttime = 0L;
        long totaltime = 0L;
        try {
            dtmcModel = new DtmcModel((Dtmc)new ResourceHelper().fromFile(this.dtmcModelFile).get(0));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new JobFailedException(e1.getLocalizedMessage());
        }
        try {
            this.rmc = new Transfomation().generateRMC(dtmcModel);
            this.rmc.computeEquations();
            System.out.println("RMC validation : " + this.rmc.validate());
            System.out.println("Equations: {");
            for (String s : this.rmc.getEquations()) {
                System.out.println(s);
            }
            System.out.println("}");
            if (!this.rmc.validate()) {
                throw new JobFailedException("Invalid RMC equations");
            }
            System.out.println("BASIC Solver");
            this.ns = new BasicSolver(this.rmc.getEquations());
            starttime = System.currentTimeMillis();
            this.ns.iterateUntilMSVlessThan(0.0, (long)Math.pow(2.0, resultPrecisionBase2));
            totaltime = System.currentTimeMillis() - starttime;
            this.ns.printCurrentAssign();
            System.out.println("Milliseconds: " + totaltime);
            System.out.println("Reliability: " + this.ns.getValue(String.valueOf(this.rmc.getInitialModule().getName()) + this.rmc.getInitialModule().getStart().getName()));
            System.out.println("MSV: " + this.ns.getMSV());
            System.out.println("Iterations: " + this.ns.getNumIterations());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JobFailedException(e.getMessage());
        }
    }

    public ReliabilityAnalysisResult getResult() {
        return new ReliabilityAnalysisResult(this.rmc, this.ns);
    }

    public String getName() {
        return "Reliability analysis";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

