/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.InitialForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.kamp.ui.workplanderivation.wizards.InitialWiazardElementsFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectOperationPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SelectOperationPage.class);
    private SurfaceFactory factory;
    private Composite container;
    private boolean justChange;
    private CompositeTaskDerivationContainer workplanContainer;
    private static final String SELECTIONCHECKBOX_TOOLTIP = "Check this, if this operation is affected within the current composite activity.";
    private static final String SIGNATURECHANGE_CHECKBOX_TOOLTIP = "Check this, if a signature change is performed with this operation.";
    private static final int POSITION_SELECTIONCHECKBOX = 0;
    private static final int POSITION_INTERFACEPORT = 1;
    private static final int POSITION_OPERATION = 2;
    private static final int POSITION_BASICACTIVITY = 3;
    private static final int POSITION_SIGNATURECHANGE = 4;
    private Map<OperationImplementationSelectionContainer, OperationSelectionContainerDecorator> container2decoratorMap;

    protected SelectOperationPage(CompositeTaskDerivationContainer workplanContainer) {
        super("");
        this.setTitle("Select Operation Activities");
        this.setDescription("Please detail your change description on operation level:\nWhich operations are affected?");
        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
        this.justChange = false;
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.createTable();
        this.setControl((Control)this.container);
    }

    public void createTable() {
        Table table = InitialWiazardElementsFactory.createTableForOperations(this.container);
        this.factory.setControlHeight((Control)table, 200);
        if (((InitialForkPage)this.getWizard().getPage("forkPage")).getFirstPage() instanceof SelectComponentActivitiesWizardPage) {
            this.setContentForComponentBeginning(table);
        } else {
            this.justChange = true;
            if (((InitialForkPage)this.getWizard().getPage("forkPage")).getFirstPage() instanceof SelectInterfacesPage) {
                this.setContentForInterfaceBeginning(table);
            } else {
                this.setContentForDatatypesBeginning(table);
            }
        }
        this.getShell().pack();
    }

    private void setContentForDatatypesBeginning(Table table) {
        if (this.workplanContainer.getLastShownDataTypeSelectionContainers().size() > 0) {
            for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getLastShownDataTypeSelectionContainers()) {
                if (!datatypeContainer.isSelected()) continue;
                for (InterfaceSelectionContainer ifaceContainer : datatypeContainer.getSelectedInterfaceSelectionContainers()) {
                    if (ifaceContainer.getFollowups().isEmpty() || !ifaceContainer.isSelected()) continue;
                    for (InterfacePortSelectionContainer ifacePortContainer : ifaceContainer.getFollowups()) {
                        if (!ifaceContainer.isSelected()) continue;
                        this.fillTable(ifacePortContainer, table);
                    }
                }
            }
        }
    }

    private void setContentForInterfaceBeginning(Table table) {
        if (this.workplanContainer.getLastShownInterfaceContainers().size() > 0) {
            for (InterfaceSelectionContainer selectedInterface : this.workplanContainer.getLastShownInterfaceContainers()) {
                if (selectedInterface.getFollowups().isEmpty() || !selectedInterface.isSelected()) continue;
                for (InterfacePortSelectionContainer followUp : selectedInterface.getFollowups()) {
                    if (!followUp.isSelected()) continue;
                    this.fillTable(followUp, table);
                }
            }
        }
    }

    private void setContentForComponentBeginning(Table table) {
        if (this.workplanContainer.getLastShownComponentContainers().size() > 0) {
            for (ComponentSelectionContainer selectedComponent : this.workplanContainer.getLastShownComponentContainers()) {
                if (selectedComponent.getRefinements().isEmpty() || !selectedComponent.isSelected()) continue;
                for (InterfacePortSelectionContainer refinement : selectedComponent.getRefinements()) {
                    if (!refinement.isSelected()) continue;
                    this.fillTable(refinement, table);
                }
            }
        }
    }

    private void fillTable(InterfacePortSelectionContainer interfacePortContainer, Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private Combo createBasicActivityCombo(TableItem itemForAssociatedOperation, InterfacePortSelectionContainer interfacePortContainer, Table table) {
        Combo combo = null;
        if (this.justChange) {
            combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.CHANGE.toString()}, table, 3);
            return combo;
        }
        switch (interfacePortContainer.getBasicActivity()) {
            case ADD: {
                combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.ADD.toString()}, table, 3);
                break;
            }
            case CHANGE: {
                combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.ADD.toString(), BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString()}, table, 3);
                break;
            }
            case REMOVE: {
                combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.REMOVE.toString()}, table, 3);
                combo.setText(BasicActivity.REMOVE.toString());
                break;
            }
            default: {
                combo = new Combo((Composite)table, 0);
            }
        }
        combo.setToolTipText("Please specify the basic activity for this operation.");
        combo.setEnabled(false);
        return combo;
    }

    private OperationSelectionContainerDecorator createDecorator(OperationImplementationSelectionContainer operationContainer, TableItem itemForAssociatedOperation, Button checkbox, Combo combo) {
        OperationSelectionContainerDecorator decorator = new OperationSelectionContainerDecorator(operationContainer);
        this.container2decoratorMap.put(operationContainer, decorator);
        itemForAssociatedOperation.setData((Object)operationContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedOperation);
        this.workplanContainer.getLastShownOperationSelectionContainer().add((Object)operationContainer);
        return decorator;
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        EList selectedItems = this.workplanContainer.getLastShownOperationSelectionContainer();
        if (selectedItems.size() < 1) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (OperationImplementationSelectionContainer abstractContainer : selectedItems) {
            if (abstractContainer.getBasicActivity() == BasicActivity.REMOVE) {
                return true;
            }
            OperationSelectionContainerDecorator container = this.container2decoratorMap.get(abstractContainer);
            if (abstractContainer.getBasicActivity() == null) {
                container.getTableItem().setBackground(4, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                this.setErrorMessage("If you check a component, you have to chose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            container.getTableItem().setBackground(4, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
        }
        return checkedAndSelected;
    }
}

