/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.RationalTextfieldsModifyListener;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NamingChangingRationalPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(NamingChangingRationalPage.class);
    private TaskRationale rationale;
    private Text textForKeyword;
    private Text textForDescription;
    private SurfaceFactory factory;

    protected NamingChangingRationalPage(TaskRationale rationale) {
        super("rationalPage");
        this.rationale = rationale;
        this.factory = new SurfaceFactory();
    }

    public void createControl(Composite parent) {
        this.setTitle("Specify New Composite Activity");
        this.setDescription("Please describe why and what you are going to change in the software system regarding the current change request.\nBy specifying composite activities you can structure work description in semantical related pieces (i.e. milestones).\nPlease provide a keyword and a longer description for each composite activity.\n");
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, true, 5, 5);
        this.createKeywordPart(container);
        this.createDescriptionPart(container);
        this.setControl((Control)container);
    }

    private void createKeywordPart(Composite container) {
        Label keyword = new Label(container, 0);
        keyword.setText("Keyword:");
        keyword.setFont(SurfaceFactory.getFontStyle().get("questionStyle"));
        this.textForKeyword = new Text(container, 2052);
        this.textForKeyword.setTextLimit(30);
        this.textForKeyword.setMessage("30 characters allowed");
        this.textForKeyword.addModifyListener((ModifyListener)new RationalTextfieldsModifyListener(this.textForKeyword, this, this.rationale, true));
    }

    private void createDescriptionPart(Composite container) {
        Label description = new Label(container, 0);
        description.setText("Description:");
        this.factory.setGridLayout((Control)description, 16384, true, 1);
        description.setFont(SurfaceFactory.getFontStyle().get("questionStyle"));
        this.textForDescription = new Text(container, 2050);
        this.factory.setGridLayout((Control)this.textForDescription, 4, true, 1);
        this.factory.setGrabVerticalForGridData((Control)this.textForDescription, true, 4);
        this.textForDescription.addModifyListener((ModifyListener)new RationalTextfieldsModifyListener(this.textForDescription, this, this.rationale, false));
    }

    public boolean canFlipToNextPage() {
        return this.textForDescription.getText().length() > 0 && this.textForKeyword.getText().length() > 0;
    }
}

