/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.dialogs;

import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddChangeRequestDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(AddChangeRequestDialog.class);
    private ChangeRequest changeRequest;
    private Composite area;
    private Text textName;
    private Text textDescription;
    private Label nameLabel;
    private Label descriptionLabel;
    private boolean edit;
    private Button checkboxforZeroModel;

    public AddChangeRequestDialog(Shell parentShell, ChangeRequest changeRequest, boolean edit) {
        super(parentShell);
        this.changeRequest = changeRequest;
        this.edit = edit;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!this.edit) {
            shell.setText("Add Change Request");
        } else {
            shell.setText("Edit Change Request");
        }
        Point curserPosition = shell.getDisplay().getCursorLocation();
        int shellWidth = 280;
        int shellHeight = 180;
        int indentionLeft = curserPosition.x;
        int indentionTop = curserPosition.y;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.area = (Composite)this.getDialogArea();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.area.setLayout((Layout)gl);
        this.createNamePart();
        this.createDescriptionPart();
        this.createCheckboxForZeroModel();
        return control;
    }

    protected void okPressed() {
        String name = this.textName.getText();
        String description = this.textDescription.getText();
        if (name != null && !name.isEmpty()) {
            this.changeRequest.setName(name);
            this.changeRequest.setDescription(description);
            if (this.checkboxforZeroModel.getSelection()) {
                this.changeRequest.setAutomaticDerivation(true);
                logger.debug((Object)"Automated derivation activated.");
            }
            super.okPressed();
        }
    }

    protected void createNamePart() {
        this.nameLabel = new Label(this.area, 0);
        this.nameLabel.setText("Name: ");
        this.textName = new Text(this.area, 2052);
        this.textName.setText(this.changeRequest.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
    }

    protected void createDescriptionPart() {
        this.descriptionLabel = new Label(this.area, 0);
        this.descriptionLabel.setText("Description: ");
        this.textDescription = new Text(this.area, 2052);
        this.textDescription.setText(this.changeRequest.getDescription());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
    }

    private void createCheckboxForZeroModel() {
        Composite wrapper = new Composite(this.area, 0);
        this.checkboxforZeroModel = new Button(wrapper, 32);
        this.checkboxforZeroModel.setText("Automated workplan derivation");
        Button helpButton = new Button(wrapper, 0);
        helpButton.setImage(this.getShell().getDisplay().getSystemImage(4));
        wrapper.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        wrapper.setLayoutData((Object)layoutData);
        helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(AddChangeRequestDialog.this.getShell());
                messageBox.setText("Information");
                messageBox.setMessage("Check this box if you want to create an workplan automatically from the difference of two models.");
                messageBox.open();
            }
        });
    }
}

