/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.adapter;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ChangeRequestContentAdapter
extends EContentAdapter {
    private static final Logger logger = Logger.getLogger(ChangeRequestContentAdapter.class);
    private Table table;
    private MaintainabilityAnalysisModel analysisModel;

    public ChangeRequestContentAdapter(Table table, MaintainabilityAnalysisModel analysisModel) {
        this.table = table;
        this.analysisModel = analysisModel;
        this.update();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == 4) {
            this.update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        this.table.removeAll();
        for (ChangeRequest changeRequest : this.analysisModel.getChangerequests()) {
            TableItem item = new TableItem(this.table, 0);
            String[] content = new String[]{changeRequest.getName(), changeRequest.getDescription(), changeRequest.isAutomaticDerivation() ? "YES" : "NO"};
            item.setText(content);
            item.setData((Object)changeRequest);
            item.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        }
        this.table.getColumn(0).pack();
    }
}

