/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.adapter;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ArchitectureAlternativesContentAdapter
extends EContentAdapter {
    private static final Logger logger = Logger.getLogger(ArchitectureAlternativesContentAdapter.class);
    private Table table;
    private MaintainabilityAnalysisModel analysisModel;

    public ArchitectureAlternativesContentAdapter(Table table, MaintainabilityAnalysisModel analysisModel) {
        this.table = table;
        this.analysisModel = analysisModel;
        this.update();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == 3) {
            this.update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        this.table.removeAll();
        for (ArchitecturalAlternative alternative : this.analysisModel.getArchitecturealternatives()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{alternative.getName(), alternative.getDescription()});
            item.setData((Object)alternative);
            item.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        }
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

