/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.general;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SurfaceFactory {
    private static final Logger logger = Logger.getLogger(SurfaceFactory.class);
    public static final String STYLE_HEADING = "headingStyle";
    public static final String STYLE_HEADING_EDITORPAGE = "editorpageheadingStyle";
    public static final String STYLE_TABLE_HEADING = "tableheadingStyle";
    public static final String STYLE_GROUP = "groupStyle";
    public static final String STYLE_QUESTION = "questionStyle";
    public static final String STYLE_TEXT = "textStyle";
    public static final String STYLE_ANSWER = "answerStyle";
    public static final String STYLE_FOOTNOTE_HEADING = "footnoteHeadingStyle";
    public static final String STYLE_FOOTNOTE_TEXT = "footnoteTextStyle";
    public static FontRegistry fontRegistry;
    public List<Widget> widgets = new ArrayList<Widget>();
    private static Map<String, Color> colorCache;

    static {
        colorCache = new HashMap<String, Color>();
    }

    public void cleanup() {
        for (Widget widget : this.widgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
    }

    public static FontRegistry getFontStyle() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry();
            fontRegistry.put(STYLE_HEADING, new FontData[]{new FontData("Helvetica", 11, 1)});
            fontRegistry.put(STYLE_HEADING_EDITORPAGE, new FontData[]{new FontData("Helvetica", 16, 0)});
            fontRegistry.put(STYLE_TABLE_HEADING, new FontData[]{new FontData("Helvetica", 10, 1)});
            fontRegistry.put(STYLE_GROUP, new FontData[]{new FontData("Helvetica", 10, 0)});
            fontRegistry.put(STYLE_QUESTION, new FontData[]{new FontData("Helvetica", 10, 1)});
            fontRegistry.put(STYLE_TEXT, new FontData[]{new FontData("Helvetica", 9, 0)});
            fontRegistry.put(STYLE_ANSWER, new FontData[]{new FontData("Helvetica", 9, 0)});
            fontRegistry.put(STYLE_FOOTNOTE_HEADING, new FontData[]{new FontData("bla", 7, 1)});
            fontRegistry.put(STYLE_FOOTNOTE_TEXT, new FontData[]{new FontData("bla", 7, 0)});
        }
        return fontRegistry;
    }

    public Color lookupColor(Display display, int red, int green, int blue, String key) {
        Color color;
        if (colorCache.containsKey(key) && (color = colorCache.get(key)) != null) {
            return color;
        }
        color = new Color((Device)display, red, green, blue);
        colorCache.put(key, color);
        return color;
    }

    public Section createSection(Composite form, String title, int sectionStyle, int horizontalAlignTableWrap, Boolean grabHorizontal, Display display, int colspan) {
        Section section = new Section(form, sectionStyle);
        section.setText(title);
        section.setTitleBarBackground(this.lookupColor(display, 210, 230, 255, "titlebar"));
        section.setBackground(this.lookupColor(display, 255, 255, 255, "background"));
        section.setForeground(this.lookupColor(display, 0, 0, 0, "foreground"));
        section.setTitleBarBorderColor(this.lookupColor(display, 0, 0, 200, "titlebarborder"));
        section.setFont(SurfaceFactory.getFontStyle().get(STYLE_GROUP));
        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignTableWrap;
        td.grabHorizontal = grabHorizontal;
        td.colspan = colspan;
        section.setLayoutData((Object)td);
        this.widgets.add((Widget)section);
        return section;
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle) {
        return this.createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton, buttonText, buttonSyle, null, null, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener) {
        return this.createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton, buttonText, buttonSyle, listener, null, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener, String[] toolTips) {
        return this.createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton, buttonText, buttonSyle, listener, toolTips, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener, String[] toolTips, Image[] images) {
        Composite compForButtons = new Composite(parent, 0);
        compForButtons.setLayout((Layout)new GridLayout());
        GridData gdCompForButtons = new GridData();
        gdCompForButtons.horizontalAlignment = 16384;
        gdCompForButtons.grabExcessHorizontalSpace = true;
        compForButtons.setLayoutData((Object)gdCompForButtons);
        int numberOfButtons = 0;
        if (buttonText != null) {
            numberOfButtons = buttonText.length;
        } else if (images != null) {
            numberOfButtons = images.length;
        }
        int i = 0;
        while (i < numberOfButtons) {
            Button button = new Button(compForButtons, buttonSyle);
            if (buttonText != null && i < buttonText.length) {
                button.setText(buttonText[i]);
            }
            GridData gdLoadButton = new GridData();
            gdLoadButton.horizontalAlignment = horizontalAlignmentButton;
            gdLoadButton.grabExcessHorizontalSpace = true;
            button.setLayoutData((Object)gdLoadButton);
            button.setFont(SurfaceFactory.getFontStyle().get(STYLE_ANSWER));
            if (listener != null && i < listener.length) {
                button.addSelectionListener((SelectionListener)listener[i]);
            }
            if (toolTips != null && i < toolTips.length) {
                button.setToolTipText(toolTips[i]);
            }
            if (images != null && i < images.length && images[i] != null) {
                button.setImage(images[i]);
            }
            ++i;
        }
        this.widgets.add((Widget)compForButtons);
        return compForButtons;
    }

    public Composite createHorizontalButtonCompositeWithToolkit(Composite parent, Boolean withLeadingLabel, String labelText, String[] buttonText, int horizontalAlignmentComp, int horizontalAlignmentButton, Display display, Boolean withToolkit, SelectionAdapter[] selectionListener) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = withToolkit != false ? toolkit.createComposite(parent) : new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        GridData gdButton = new GridData();
        GridData gdComp = new GridData();
        gdComp.horizontalAlignment = horizontalAlignmentComp;
        gl.numColumns = withLeadingLabel != false ? buttonText.length + 1 : buttonText.length;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)gdComp);
        if (withLeadingLabel.booleanValue()) {
            Label label = new Label(comp, 0);
            this.widgets.add((Widget)label);
            label.setText(labelText);
            label.setFont(SurfaceFactory.getFontStyle().getBold(STYLE_ANSWER));
        }
        int i = 0;
        while (i < buttonText.length) {
            Button button = new Button(comp, 0);
            button.setText(buttonText[i]);
            button.setFont(SurfaceFactory.getFontStyle().get(STYLE_ANSWER));
            gdButton.horizontalAlignment = horizontalAlignmentButton;
            button.setLayoutData((Object)gdButton);
            this.widgets.add((Widget)button);
            button.addSelectionListener((SelectionListener)selectionListener[i]);
            ++i;
        }
        this.widgets.add((Widget)comp);
        return comp;
    }

    public Table createTable(Composite parent, int horizontalSpan, String[] columns, int horizontalAlignment, boolean grabHorizontal) {
        Table table = new Table(parent, 67588);
        table.setLayout((Layout)new GridLayout());
        GridData gdTable = new GridData();
        gdTable.horizontalAlignment = horizontalAlignment;
        gdTable.horizontalSpan = horizontalSpan;
        gdTable.grabExcessHorizontalSpace = grabHorizontal;
        table.setLayoutData((Object)gdTable);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SurfaceFactory.getFontStyle().get(STYLE_TABLE_HEADING));
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            ++i;
        }
        int j = 0;
        while (j < table.getColumnCount()) {
            table.getColumn(j).pack();
            ++j;
        }
        this.widgets.add((Widget)table);
        return table;
    }

    public Tree createTree(Composite parent, int horizontalAlignment, int horizontalSpan, boolean grabHorizontal, int style, String[] columns) {
        Tree tree = new Tree(parent, style | 0x100 | 0x200);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData treeData = new GridData();
        treeData.horizontalAlignment = horizontalAlignment;
        treeData.horizontalSpan = horizontalSpan;
        treeData.grabExcessHorizontalSpace = grabHorizontal;
        tree.setLayoutData((Object)treeData);
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnText = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 0x1000000);
            column.setText(columnText);
            column.pack();
            this.widgets.add((Widget)column);
            ++n2;
        }
        this.widgets.add((Widget)tree);
        return tree;
    }

    public void fillTable(Table table) {
        int i = 0;
        while (i < 100) {
            TableItem item = new TableItem(table, 0);
            item.setFont(SurfaceFactory.getFontStyle().get(STYLE_TEXT));
            int j = 0;
            while (j < table.getColumnCount()) {
                if (table.getColumn(j).getText() == "ID") {
                    item.setText(j, String.valueOf(i));
                } else {
                    item.setText(j, "Item " + i);
                }
                ++j;
            }
            this.widgets.add((Widget)item);
            ++i;
        }
    }

    public Composite createCompositeOrGroup(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, boolean group) {
        return this.createCompositeOrGroup(container, numClumns, horizontalAlignment, horizontalSpan, compositeStyle, group, 5, 5);
    }

    public Composite createCompositeOrGroup(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, boolean group, int marginWidth, int marginHeight) {
        Composite comp;
        GridLayout glUp = new GridLayout();
        glUp.numColumns = numClumns;
        glUp.marginWidth = marginWidth;
        glUp.marginHeight = marginHeight;
        GridData gdUp = new GridData();
        gdUp.horizontalAlignment = horizontalAlignment;
        gdUp.horizontalSpan = horizontalSpan;
        if (!group) {
            comp = new Composite(container, compositeStyle);
            comp.setLayout((Layout)glUp);
            comp.setLayoutData((Object)gdUp);
        } else {
            comp = new Group(container, compositeStyle);
            comp.setLayout((Layout)glUp);
            comp.setLayoutData((Object)gdUp);
        }
        this.widgets.add((Widget)comp);
        return comp;
    }

    public void createHeading(Composite upperPart, String title, int horizontalSpan, int horizontalAlignment, boolean group) {
        if (group) {
            Group labelGroup = new Group(upperPart, 0);
            labelGroup.setLayout((Layout)new GridLayout());
            GridData gdGroup = new GridData();
            gdGroup.grabExcessHorizontalSpace = true;
            gdGroup.horizontalAlignment = horizontalAlignment;
            gdGroup.horizontalSpan = horizontalSpan;
            labelGroup.setLayoutData((Object)gdGroup);
            this.widgets.add((Widget)labelGroup);
            Label AALabel = new Label((Composite)labelGroup, 0);
            AALabel.setText(title);
            AALabel.setFont(SurfaceFactory.getFontStyle().getBold(STYLE_TEXT));
            this.widgets.add((Widget)AALabel);
        } else {
            Label AALabel = new Label(upperPart, 0);
            AALabel.setText(title);
            this.widgets.add((Widget)AALabel);
            GridData gdLabel = new GridData();
            gdLabel.grabExcessHorizontalSpace = true;
            gdLabel.horizontalAlignment = horizontalAlignment;
            gdLabel.horizontalSpan = horizontalSpan;
            AALabel.setLayoutData((Object)gdLabel);
            AALabel.setFont(SurfaceFactory.getFontStyle().getBold(STYLE_TEXT));
        }
    }

    public Composite createCompositeForSection(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, int marginWidth, int marginHeight, Display display) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = toolkit.createComposite(container, compositeStyle);
        this.widgets.add((Widget)comp);
        GridLayout gl = new GridLayout();
        gl.numColumns = numClumns;
        gl.verticalSpacing = 25;
        gl.marginWidth = marginWidth;
        gl.marginHeight = marginHeight;
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.horizontalSpan = horizontalSpan;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)gd);
        return comp;
    }

    public Composite createHorizontalButtonsForEclipseForm(Display display, Composite parent, String[] buttonTexts, SelectionAdapter[] listeners, int horizontalAlignmentComp, int horizontalAlignmentButton, boolean makeColumnsEqualWidth, List<Widget> widgets) {
        return this.createHorizontalButtonsForEclipseForm(display, parent, buttonTexts, listeners, horizontalAlignmentComp, horizontalAlignmentButton, makeColumnsEqualWidth, null, widgets);
    }

    public Composite createHorizontalButtonsForEclipseForm(Display display, Composite parent, String[] buttonTexts, SelectionAdapter[] listeners, int horizontalAlignmentComp, int horizontalAlignmentButton, boolean makeColumnsEqualWidth, Image[] buttonImages, List<Widget> widgets) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite compositeForButtons = toolkit.createComposite(parent, 0);
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        twLayout.numColumns = buttonTexts.length;
        twLayout.bottomMargin = 1;
        twLayout.topMargin = 1;
        twLayout.leftMargin = 1;
        twLayout.rightMargin = 1;
        compositeForButtons.setLayout((Layout)twLayout);
        widgets.add((Widget)compositeForButtons);
        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignmentComp;
        td.grabHorizontal = true;
        compositeForButtons.setData((Object)td);
        int i = 0;
        while (i < buttonTexts.length) {
            TableWrapData gd = new TableWrapData();
            gd.grabHorizontal = true;
            gd.align = horizontalAlignmentButton;
            Button button = toolkit.createButton(compositeForButtons, buttonTexts[i], 0);
            if (buttonImages != null && i < buttonImages.length) {
                button.setImage(buttonImages[i]);
            }
            button.setLayoutData((Object)gd);
            button.addSelectionListener((SelectionListener)listeners[i]);
            widgets.add((Widget)button);
            ++i;
        }
        return compositeForButtons;
    }

    public Label createIndentedLabel(Composite parent, String labelText, int indent, int style, List<Widget> widgetList) {
        Label label = new Label(parent, style);
        label.setText(labelText);
        GridData gd = new GridData();
        gd.widthHint = indent;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        label.setLayoutData((Object)gd);
        widgetList.add((Widget)label);
        this.widgets.add((Widget)label);
        return label;
    }

    public Button createFirstLevelOptionRadio(Composite parent, String optionText, int horizontalSpan, List<Widget> widgetList) {
        Button button = new Button(parent, 16);
        button.setText(optionText);
        GridLayout gdB = new GridLayout();
        gdB.numColumns = 2;
        widgetList.add((Widget)button);
        this.widgets.add((Widget)button);
        return button;
    }

    public Group createGroupWithWhiteBackgroundTableWrap(Display display, Composite comp, String text, int horizontalAlignment, Boolean grabExcessHorizontalSpace, int horizontalSpan, int numColumns) {
        Group group = new Group(comp, 0);
        group.setText(text);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        TableWrapData wrapData = new TableWrapData();
        wrapData.grabHorizontal = grabExcessHorizontalSpace;
        wrapData.align = horizontalAlignment;
        wrapData.colspan = horizontalSpan;
        group.setLayoutData((Object)wrapData);
        group.setBackground(this.lookupColor(display, 255, 255, 255, "background"));
        this.widgets.add((Widget)group);
        return group;
    }

    public Composite createCompositeForEclipseForm(Display display, Composite parent, int compStyle, int alignWrap, Boolean grabHorizontal, int colspan, int numColumns) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = toolkit.createComposite(parent, compStyle);
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = numColumns;
        TableWrapData twd = new TableWrapData();
        twd.align = alignWrap;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        comp.setLayout((Layout)twl);
        comp.setLayoutData((Object)twd);
        this.widgets.add((Widget)comp);
        return comp;
    }

    public Table createTableWithToolkit(Display display, Composite parent, int tableStyle, String[] headers, Boolean grabHorizontal, int horizontalAlignment, int colspan) {
        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        twd.heightHint = 100;
        table.setLayoutData((Object)twd);
        this.widgets.add((Widget)table);
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(headers[i]);
            tc.pack();
            this.widgets.add((Widget)tc);
            ++i;
        }
        return table;
    }

    public Table createTableForAnalysisInstanceLayer(Display display, Composite parent, int tableStyle, String[] headers, Boolean grabHorizontal, int horizontalAlignment, int colspan) {
        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        table.setLayoutData((Object)twd);
        table.setFont(SurfaceFactory.getFontStyle().get(STYLE_QUESTION));
        this.widgets.add((Widget)table);
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(headers[i]);
            tc.pack();
            this.widgets.add((Widget)tc);
            ++i;
        }
        return table;
    }

    public Tree createTreeforEclipseForm(Display display, Composite parent, String[] columns, int align, Boolean grabHorizontal, int colspan, int heightHint) {
        FormToolkit toolkit = new FormToolkit(display);
        Tree tree = toolkit.createTree(parent, 67584);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.widgets.add((Widget)tree);
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.colspan = colspan;
        data.heightHint = heightHint;
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setText(columns[i]);
            column.pack();
            this.widgets.add((Widget)column);
            ++i;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(SurfaceFactory.getFontStyle().get(STYLE_TABLE_HEADING));
        return tree;
    }

    public void removeArchitectureAlternativeFromOverviewTable(Table table, int index) {
        try {
            TableEditor editor = new TableEditor(table);
            editor.getEditor().dispose();
            table.remove(index);
            table.update();
        }
        catch (Exception exception) {}
    }

    public Composite createButtonComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.widgets.add((Widget)comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)data);
        comp.setBackground(this.lookupColor(comp.getDisplay(), 255, 255, 255, "background"));
        return comp;
    }

    public Button createButton(Composite parent, Image image, SelectionAdapter listener) {
        Button button = this.createButton(parent, "", listener);
        button.setImage(image);
        return button;
    }

    public Button createButton(Composite parent, String text, SelectionAdapter listener) {
        Button button = new Button(parent, 0);
        this.widgets.add((Widget)button);
        if (!text.equals("")) {
            button.setText(text);
        }
        button.addSelectionListener((SelectionListener)listener);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public void setControlWithTableEditor(Table table, TableItem item, Control control, int column) {
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public void setControlWithTableTreeEditor(Tree tree, TreeItem item, Control control, int column) {
        TreeEditor editor = new TreeEditor(tree);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public Combo createCombo(TableItem itemForAssociatedInterface, String[] itemsToAdd, Table table, int column) {
        Combo combo = new Combo((Composite)table, 8);
        this.widgets.add((Widget)combo);
        String[] stringArray = itemsToAdd;
        int n = itemsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            combo.add(text);
            ++n2;
        }
        this.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)combo, column);
        return combo;
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan, boolean grabHorizintal, Color background) {
        this.configureCompositeForTableWrapLayout(composite, numColumns, align, colspan, grabHorizintal, background, -1);
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan, boolean grabHorizintal, Color background, int maxWidth) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.bottomMargin = 1;
        layout.topMargin = 1;
        layout.leftMargin = 1;
        layout.rightMargin = 2;
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.colspan = colspan;
        data.grabHorizontal = grabHorizintal;
        if (maxWidth != -1) {
            data.maxWidth = maxWidth;
        }
        composite.setBackground(background);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
    }

    public void createButtonsForGivenTableWrapComposite(Composite parent, String[] buttonText, int alignmentButton, int buttonStyle, boolean grabHorizontal, SelectionAdapter[] listeners) {
        this.createButtonsForGivenTableWrapComposite(parent, buttonText, alignmentButton, buttonStyle, grabHorizontal, listeners, null);
    }

    public void createButtonsForGivenTableWrapComposite(Composite parent, String[] buttonText, int alignmentButton, int buttonStyle, boolean grabHorizontal, SelectionAdapter[] listeners, Image[] buttonImages) {
        int i = 0;
        String[] stringArray = buttonText;
        int n = buttonText.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            Button button = new Button(parent, buttonStyle);
            button.setText(text);
            this.widgets.add((Widget)button);
            if (listeners[i] != null) {
                button.addSelectionListener((SelectionListener)listeners[i]);
            }
            if (buttonImages != null && i < buttonImages.length) {
                button.setImage(buttonImages[i]);
            }
            TableWrapData td = new TableWrapData();
            td.align = alignmentButton;
            td.grabHorizontal = grabHorizontal;
            button.setLayoutData((Object)td);
            ++i;
            ++n2;
        }
    }

    public Button createChangeSelectionButton(Composite parent, String text, int TODO, int style) {
        Button button = new Button(parent, style);
        this.widgets.add((Widget)button);
        return button;
    }

    public void setSizeForControl(Composite composite, int widthHint, int heighHint, boolean useWidthHint) {
        if (composite.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)composite.getLayoutData();
            gd.heightHint = heighHint;
            if (useWidthHint) {
                gd.widthHint = widthHint;
            }
        } else if (composite.getLayoutData() instanceof TableWrapData) {
            TableWrapData twd = (TableWrapData)composite.getLayoutData();
            twd.heightHint = heighHint;
        }
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment) {
        this.setGrabVerticalForGridData(control, grabVertical, verticalAlignment, false);
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment, boolean setGridData) {
        if (control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.grabExcessVerticalSpace = grabVertical;
            gd.verticalAlignment = verticalAlignment;
        } else if (setGridData) {
            GridData gd = new GridData();
            gd.grabExcessVerticalSpace = grabVertical;
            gd.verticalAlignment = verticalAlignment;
            control.setLayoutData((Object)gd);
        }
    }

    public void setGrabVerticalForTableWrapData(Control control, boolean grabVertical, int vAlign) {
        if (control.getLayoutData() == null) {
            control.setLayoutData((Object)new TableWrapData());
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            TableWrapData twd = (TableWrapData)control.getLayoutData();
            twd.grabVertical = grabVertical;
            twd.valign = vAlign;
        }
    }

    public void setControlHeight(Control control, int heighHint) {
        if (control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).heightHint = heighHint;
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            ((TableWrapData)control.getLayoutData()).heightHint = heighHint;
        }
    }

    public void setGridLayout(Control control, int horizontalAlignment, boolean grabHorizontal, int horizontalSpan) {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = horizontalAlignment;
        layoutData.grabExcessHorizontalSpace = grabHorizontal;
        layoutData.horizontalSpan = horizontalSpan;
        control.setLayoutData((Object)layoutData);
    }

    public void setTableWrapData(Control control, int align, boolean grabHorizontal, int valign, boolean grabVertical, int colspan) {
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.valign = valign;
        data.grabVertical = grabVertical;
        data.colspan = colspan;
        control.setLayoutData((Object)data);
    }

    public void setControlWidth(Control control, int widthHint) {
        if (control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).widthHint = widthHint;
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            ((TableWrapData)control.getLayoutData()).maxWidth = widthHint;
        }
    }

    public Button createButton(Composite parent, String text, int style, Image image, SelectionAdapter selectionAdapter) {
        Button button = this.createButton(parent, text, style);
        if (image != null) {
            button.setImage(image);
        }
        if (selectionAdapter != null) {
            button.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return button;
    }

    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        this.widgets.add((Widget)button);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public void packTableColums(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

