/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.general;

import de.fzi.kamp.service.analysisinstance.AnalysisAlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.commands.EditArchiAltCommand;
import de.fzi.kamp.service.commands.LoadArchiAltCommand;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.kamp.ui.analysisoverview.dialog.AddAnalysisInstanceAndhangeRequestDialog;
import de.fzi.kamp.ui.preparation.dialogs.AddChangeRequestDialog;
import de.fzi.kamp.ui.preparation.dialogs.ArchitectureAlternativeLoadDialog;
import de.fzi.kamp.ui.workorganisation.MapElementsToDevelopersDialog;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.widgets.Display;

public class DialogManager
implements IDialogManager {
    private static final Logger logger = Logger.getLogger(DialogManager.class);
    private IMainEditor mainEditor;

    public DialogManager(IMainEditor commandHandler) {
        this.mainEditor = commandHandler;
    }

    public void showCheckComplexityAnnotationsWizard() {
    }

    public void showEditArchitectureAlternativeDialog(ArchitecturalAlternative architectureAlternative, IPreparationManager preparationManager) {
        ArchitectureAlternativeLoadDialog dialog = new ArchitectureAlternativeLoadDialog(null, null, null, true, architectureAlternative);
        dialog.create();
        if (dialog.open() == 0) {
            EditArchiAltCommand command = new EditArchiAltCommand(preparationManager, architectureAlternative);
            this.mainEditor.handleCommand((Command)command);
        }
    }

    public boolean showEditChangeRequestDialog(ChangeRequest changeRequest) {
        AddChangeRequestDialog dialog = new AddChangeRequestDialog(null, changeRequest, true);
        dialog.create();
        return dialog.open() == 0;
    }

    public boolean showNewChangeRequestDialog(ChangeRequest changeRequest) {
        AddChangeRequestDialog dialog = new AddChangeRequestDialog(null, changeRequest, false);
        dialog.create();
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    public List<AbstractArchitectureModel> showSelectArchitectureModelDialog(MaintainabilityAnalysisModel analysisModel, List<AbstractArchitectureModel> architectureModelList, List<AbstractArchitectureModel> selectedModels, ArchitecturalAlternative alternative, PreparationManager preparationManager) {
        ArchitectureAlternativeLoadDialog dialog = new ArchitectureAlternativeLoadDialog(null, architectureModelList, selectedModels, false, alternative);
        dialog.create();
        if (dialog.open() == 32) {
            LoadArchiAltCommand loadArchiAltCommand = new LoadArchiAltCommand(analysisModel, selectedModels, alternative, preparationManager);
            this.mainEditor.handleCommand((Command)loadArchiAltCommand);
        }
        return selectedModels;
    }

    public AnalysisAlternativeAndChangeRequestTuple showSelectArchitectureAlternativeAndChangeRequestDialog(MaintainabilityAnalysisModel analysisModel) {
        AnalysisAlternativeAndChangeRequestTuple result = new AnalysisAlternativeAndChangeRequestTuple();
        AddAnalysisInstanceAndhangeRequestDialog dialog = new AddAnalysisInstanceAndhangeRequestDialog(this.mainEditor, analysisModel, result, this.mainEditor.getArchitectureModelProvider());
        dialog.create();
        dialog.open();
        return result;
    }

    public void openMapElementsToDevelopersDialog(WorkOrganisationModel workorganisation, AbstractArchitectureModel architectureModel, Display display, ICommandHandler commandHandler) {
        MapElementsToDevelopersDialog dialog = new MapElementsToDevelopersDialog(display.getActiveShell(), workorganisation, architectureModel, commandHandler);
        dialog.create();
        dialog.open();
    }

    public void showSelectAffectedFollowUpComponent() {
    }
}

