/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.adapters;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.widgets.Button;

public class AnalysisInstanceItemAdapter
implements Adapter {
    private static final Logger logger = Logger.getLogger(AnalysisInstanceItemAdapter.class);
    private Button deriveWorkplanButton;
    private Button editWorkplanButton;
    private Button calculateWorkcomplexityButton;
    private Button effortEstimationInterviewButton;
    private Button effortEstimationEditButton;
    private Button showResultSummaryButton;
    private IAnalysisInstanceManager analysisInstanceManager;
    private EffortAnalysisInstance analysisInstance;
    private Notifier target;

    public AnalysisInstanceItemAdapter(IAnalysisInstanceManager analysisInstanceManager, EffortAnalysisInstance analysisInstance) {
        this.analysisInstanceManager = analysisInstanceManager;
        this.analysisInstance = analysisInstance;
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof EffortAnalysisInstance;
    }

    public void notifyChanged(Notification notification) {
        if (this.analysisInstance != null) {
            this.checkWorkplanDeriveButton();
            this.checkWorkplanEditButton();
            this.checkEffortEstimationEditButton();
        }
    }

    public void manualUpdateAfterautomaticDerivation() {
        if (this.analysisInstance != null) {
            this.checkWorkplanDeriveButton();
            this.checkWorkplanEditButton();
            this.checkEffortEstimationEditButton();
        }
    }

    private void checkWorkplanDeriveButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledDeriveWorkPlanForAnalysisInstance(this.analysisInstance);
        if (!this.deriveWorkplanButton.isDisposed()) {
            this.deriveWorkplanButton = this.setEnablementOfButton(this.deriveWorkplanButton, enabled);
        }
    }

    private void checkWorkplanEditButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledEditWorkPlanForAnalysisInstance(this.analysisInstance);
        if (!this.editWorkplanButton.isDisposed()) {
            this.editWorkplanButton = this.setEnablementOfButton(this.editWorkplanButton, enabled);
        }
    }

    private void checkCalculateWorkcomplexityButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledCalculateWorkComplexityForAnalysisInstance(this.analysisInstance);
        if (!this.calculateWorkcomplexityButton.isDisposed()) {
            this.calculateWorkcomplexityButton = this.setEnablementOfButton(this.calculateWorkcomplexityButton, enabled);
        }
    }

    private void checkEffortEstimationInterviewButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledStartEffortEstimationInterview(this.analysisInstance);
        if (!this.effortEstimationInterviewButton.isDisposed()) {
            this.effortEstimationInterviewButton = this.setEnablementOfButton(this.effortEstimationInterviewButton, enabled);
        }
    }

    private void checkEffortEstimationEditButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledEditEffortEstimates(this.analysisInstance);
        if (!this.effortEstimationEditButton.isDisposed()) {
            this.effortEstimationEditButton = this.setEnablementOfButton(this.effortEstimationEditButton, enabled);
        }
    }

    private void checkShowResultSummaryButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledShowResultSummary(this.analysisInstance);
        if (!this.showResultSummaryButton.isDisposed()) {
            this.showResultSummaryButton = this.setEnablementOfButton(this.showResultSummaryButton, enabled);
        }
    }

    private Button setEnablementOfButton(Button button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        return button;
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public void setDeriveWorkplanButton(Button deriveWorkplan) {
        this.deriveWorkplanButton = deriveWorkplan;
        this.checkWorkplanDeriveButton();
    }

    public void setEditWorkspaceButton(Button editWorkspaceButton) {
        this.editWorkplanButton = editWorkspaceButton;
        this.checkWorkplanEditButton();
    }

    public void setCalculateWorkcomplexityButton(Button calculateWorkcomplexityButton) {
        this.calculateWorkcomplexityButton = calculateWorkcomplexityButton;
        this.checkCalculateWorkcomplexityButton();
    }

    public void setEffortEstimationInterviewButton(Button effortEstimationInterviewButton) {
        this.effortEstimationInterviewButton = effortEstimationInterviewButton;
        this.checkEffortEstimationInterviewButton();
    }

    public void setEffortEstimationEditButton(Button effortEstimationEditButton) {
        this.effortEstimationEditButton = effortEstimationEditButton;
        this.checkEffortEstimationEditButton();
    }

    public void setShowResultSummaryButton(Button showResultSummaryButton) {
        this.showResultSummaryButton = showResultSummaryButton;
        this.checkShowResultSummaryButton();
    }

    public void setAnalysisInstanceManager(IAnalysisInstanceManager analysisInstanceManager) {
        this.analysisInstanceManager = analysisInstanceManager;
    }

    public void setAnalysisInstance(EffortAnalysisInstance analysisInstance) {
        this.analysisInstance = analysisInstance;
    }
}

