/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.preparation.impl;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.commands.AddChangeRequestCommand;
import de.fzi.kamp.service.commands.CheckComplexityAnnotationsCommand;
import de.fzi.kamp.service.commands.EditChangeRequestCommand;
import de.fzi.kamp.service.commands.RemoveArchiAltCommand;
import de.fzi.kamp.service.commands.RemoveChangeRequestCommand;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.widgets.Display;

public class PreparationManager
implements IPreparationManager {
    private static final Logger logger = Logger.getLogger(PreparationManager.class);
    private MaintainabilityAnalysisModel analysisModel;
    private IArchitectureModelProvider architectureModelProvider;
    private IDialogManager dialogManager;
    private ICommandHandler commandHandler;

    public PreparationManager(MaintainabilityAnalysisModel analysisModel, IArchitectureModelProvider provider, IDialogManager dialogManager, ICommandHandler commandHandler) {
        this.architectureModelProvider = provider;
        this.analysisModel = analysisModel;
        this.dialogManager = dialogManager;
        this.commandHandler = commandHandler;
    }

    @Override
    public List<ArchitecturalAlternative> loadAndSelectArchitectureModels() {
        List<AbstractArchitectureModel> architectureModelList = this.architectureModelProvider.getArchitectureModels();
        ArchitecturalAlternative alternative = WorkplanFactory.eINSTANCE.createArchitecturalAlternative();
        LinkedList<AbstractArchitectureModel> selectedModels = new LinkedList<AbstractArchitectureModel>();
        this.dialogManager.showSelectArchitectureModelDialog(this.analysisModel, architectureModelList, selectedModels, alternative, this);
        return this.getArchitectureAlternatives();
    }

    @Override
    public List<ArchitecturalAlternative> getArchitectureAlternatives() {
        return this.analysisModel.getArchitecturealternatives();
    }

    @Override
    public void editArchitectureAlternative(ArchitecturalAlternative architectureAlternative) {
        this.dialogManager.showEditArchitectureAlternativeDialog(architectureAlternative, this);
    }

    @Override
    public void checkComplexityAnnotationsForArchitectureAlternative(ArchitecturalAlternative architectureAlternative) {
        CheckComplexityAnnotationsCommand command = new CheckComplexityAnnotationsCommand(this, architectureAlternative);
        this.commandHandler.handleCommand((Command)command);
    }

    @Override
    public void removeArchitectureAlternative(ArchitecturalAlternative architectureAlternative) {
        RemoveArchiAltCommand command = new RemoveArchiAltCommand(architectureAlternative, this.analysisModel);
        this.commandHandler.handleCommand((Command)command);
    }

    @Override
    public void addChangeRequest() {
        ChangeRequest changeRequest = this.createChangeRequest("", "");
        if (this.dialogManager.showNewChangeRequestDialog(changeRequest)) {
            AddChangeRequestCommand command = new AddChangeRequestCommand(this, changeRequest);
            this.commandHandler.handleCommand((Command)command);
        }
    }

    @Override
    public List<ChangeRequest> getChangeRequests() {
        return this.analysisModel.getChangerequests();
    }

    @Override
    public void editChangeRequest(ChangeRequest changeRequest) {
        if (this.dialogManager.showEditChangeRequestDialog(changeRequest)) {
            EditChangeRequestCommand command = new EditChangeRequestCommand(this, changeRequest);
            this.commandHandler.handleCommand((Command)command);
        }
    }

    @Override
    public void removeChangeRequest(ChangeRequest changeRequest) {
        RemoveChangeRequestCommand command = new RemoveChangeRequestCommand(this, changeRequest);
        this.commandHandler.handleCommand((Command)command);
    }

    @Override
    public MaintainabilityAnalysisModel getAnalysisModel() {
        return this.analysisModel;
    }

    @Override
    public IArchitectureModelProvider getArchitectureModelProvider() {
        return this.architectureModelProvider;
    }

    public IDialogManager getDialogManager() {
        return this.dialogManager;
    }

    @Override
    public void openMapElementsToDevelopersDialog(WorkOrganisationModel workorganisation, AbstractArchitectureModel architectureModel, Display display, IMainEditor editor) {
        this.dialogManager.openMapElementsToDevelopersDialog(workorganisation, architectureModel, display, editor);
    }

    private ChangeRequest createChangeRequest(String name, String description) {
        ChangeRequest changeRequest = WorkplanFactory.eINSTANCE.createChangeRequest();
        changeRequest.setName(name);
        changeRequest.setDescription(description);
        return changeRequest;
    }
}

