/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.commands;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

public class LoadArchiAltCommand
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(LoadArchiAltCommand.class);
    private MaintainabilityAnalysisModel analysisModel;
    private List<AbstractArchitectureModel> selectedModels;
    private ArchitecturalAlternative alternative;
    private PreparationManager preparationManager;

    public LoadArchiAltCommand(MaintainabilityAnalysisModel analysisModel, List<AbstractArchitectureModel> selectedModels, ArchitecturalAlternative alternative, PreparationManager preparationManager) {
        this.analysisModel = analysisModel;
        this.selectedModels = selectedModels;
        this.alternative = alternative;
        this.preparationManager = preparationManager;
    }

    public void execute() {
        for (AbstractArchitectureModel selected : this.selectedModels) {
            if (this.alternativeExisting(selected)) continue;
            this.alternative.setArchitecturemodel(selected);
            this.analysisModel.getArchitecturealternatives().add((Object)this.alternative);
        }
    }

    private boolean alternativeExisting(AbstractArchitectureModel selected) {
        boolean exists = false;
        for (ArchitecturalAlternative alternativesThere : this.preparationManager.getArchitectureAlternatives()) {
            if (!selected.getName().equals(alternativesThere.getName())) continue;
            exists = true;
        }
        return exists;
    }

    public void redo() {
    }

    public void undo() {
        logger.debug((Object)"This is the undo functionality, in the end.");
        super.undo();
    }

    public boolean canExecute() {
        return this.analysisModel != null;
    }
}

