/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.commands;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.NewWorkplanBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

public class DeriveWorkplanCommand
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(DeriveWorkplanCommand.class);
    private IMainEditor mainEditor;
    private Workplan workplan;
    private CompositeTaskDerivationContainer compositeTaskContainer;
    private WorkplanDerivationManager workplanDerivationManager;

    public DeriveWorkplanCommand(Workplan workplan, IMainEditor mainEditor, CompositeTaskDerivationContainer compositeTaskContainer, WorkplanDerivationManager workplanDerivationManager) {
        this.workplan = workplan;
        this.mainEditor = mainEditor;
        this.compositeTaskContainer = compositeTaskContainer;
        this.workplanDerivationManager = workplanDerivationManager;
    }

    public void execute() {
        this.workplanDerivationManager.resetLastSelectedLists();
        new NewWorkplanBuilder(this.mainEditor).fillTasklistOfWorkplan(this.compositeTaskContainer, this.workplan);
        this.mainEditor.showWorkplanChanges(this.workplan, false);
        this.mainEditor.getCentralPage().setAddCompositeActivityButtonVisible();
    }

    public void redo() {
    }

    public boolean canExecute() {
        if (this.mainEditor != null && this.workplan != null && this.workplanDerivationManager != null && this.compositeTaskContainer != null) {
            return true;
        }
        return super.canExecute();
    }
}

