/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.derivation;

import de.fzi.kamp.derivation.DiffWorkplanBuilder;
import de.fzi.kamp.derivation.ParentSwitch;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.metamodel.util.DiffSwitch;
import org.eclipse.emf.ecore.EObject;

public class DiffModelVisitor
extends DiffSwitch<EObject> {
    private static final Logger logger = Logger.getLogger(DiffModelVisitor.class);
    private DiffWorkplanBuilder workplanBuilder;

    public DiffModelVisitor(DiffWorkplanBuilder workplanBuilder) {
        this.workplanBuilder = workplanBuilder;
    }

    public EObject caseModelElementChangeLeftTarget(ModelElementChangeLeftTarget object) {
        EObject parent = object.getRightParent();
        EObject element = object.getLeftElement();
        logger.info((Object)"Case LEFT TARGET");
        this.handleElement(BasicActivity.ADD, parent, element);
        return object;
    }

    public EObject caseModelElementChangeRightTarget(ModelElementChangeRightTarget object) {
        EObject parent = object.getLeftParent();
        EObject element = object.getRightElement();
        logger.info((Object)"Case RIGHT TARGET");
        this.handleElement(BasicActivity.REMOVE, parent, element);
        return object;
    }

    public EObject caseAttributeChange(AttributeChange object) {
        logger.info((Object)"Case ATTRIBUTE CHANGE");
        return object;
    }

    public EObject caseReferenceChange(ReferenceChange object) {
        logger.info((Object)"Case REFERENCE CHANGE");
        return object;
    }

    public EObject caseUpdateReference(UpdateReference object) {
        EObject leftElement;
        if (object.getReference().getName().equals("interfaceType") && (leftElement = object.getLeftElement()) instanceof InterfacePort) {
            Interface newInterfaceType = ((InterfacePort)leftElement).getInterfaceType();
            logger.info((Object)("Changed interface type of " + leftElement.toString() + " to " + newInterfaceType.toString()));
        }
        return object;
    }

    public EObject caseDiffGroup(DiffGroup object) {
        for (DiffElement element : object.getSubDiffElements()) {
            this.doSwitch((EObject)element);
        }
        return object;
    }

    public EObject defaultCase(EObject object) {
        logger.info((Object)("DEFAULT CASE REACHED!!! Class: " + object.getClass()));
        return object;
    }

    private void handleElement(BasicActivity basicActivity, EObject parent, EObject element) {
        ParentSwitch parentSwitch = new ParentSwitch(element, basicActivity, this.workplanBuilder);
        parentSwitch.doSwitch(parent);
    }
}

