//
// Copyright (C) 2006 United States Government as represented by the
// Administrator of the National Aeronautics and Space Administration
// (NASA).  All Rights Reserved.
// 
// This software is distributed under the NASA Open Source Agreement
// (NOSA), version 1.3.  The NOSA has been approved by the Open Source
// Initiative.  See the file NOSA-1.3-JPF at the top of the distribution
// directory tree for the complete NOSA document.
// 
// THE SUBJECT SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY OF ANY
// KIND, EITHER EXPRESSED, IMPLIED, OR STATUTORY, INCLUDING, BUT NOT
// LIMITED TO, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL CONFORM TO
// SPECIFICATIONS, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR
// A PARTICULAR PURPOSE, OR FREEDOM FROM INFRINGEMENT, ANY WARRANTY THAT
// THE SUBJECT SOFTWARE WILL BE ERROR FREE, OR ANY WARRANTY THAT
// DOCUMENTATION, IF PROVIDED, WILL CONFORM TO THE SUBJECT SOFTWARE.
//
package gov.nasa.jpf.jvm.abstraction.filter;


import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * USE CAREFULLY - Indicates that the stack frame of a method should not,
 * in specified ways, be considered during state matching.
 * 
 * This can easily cause the search to be cut off even though the VM has made
 * progress, so USE WISELY!
 * 
 * @author peterd
 */
@Target({ElementType.METHOD})
public @interface FilterFrame {
  /**
   * True means locals (incl. parameters) and operand stack will be filtered.
   */
  boolean filterData() default true;

  /**
   * True means the location of the next instruction will be filtered.
   */
  boolean filterPC() default true;

  /**
   * True means frames below this one will not appear at all in the abstracted
   * state.
   */
  boolean filterSubframes() default true;
}