//
// Copyright (C) 2009 United States Government as represented by the
// Administrator of the National Aeronautics and Space Administration
// (NASA).  All Rights Reserved.
//
// This software is distributed under the NASA Open Source Agreement
// (NOSA), version 1.3.  The NOSA has been approved by the Open Source
// Initiative.  See the file NOSA-1.3-JPF at the top of the distribution
// directory tree for the complete NOSA document.
//
// THE SUBJECT SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY OF ANY
// KIND, EITHER EXPRESSED, IMPLIED, OR STATUTORY, INCLUDING, BUT NOT
// LIMITED TO, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL CONFORM TO
// SPECIFICATIONS, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR
// A PARTICULAR PURPOSE, OR FREEDOM FROM INFRINGEMENT, ANY WARRANTY THAT
// THE SUBJECT SOFTWARE WILL BE ERROR FREE, OR ANY WARRANTY THAT
// DOCUMENTATION, IF PROVIDED, WILL CONFORM TO THE SUBJECT SOFTWARE.
//

package gov.nasa.jpf.jvm;

/**
 * base class for atomic field updaters
 * NOTE - since all native methods are static, we have to be too
 */
public class AtomicFieldUpdater {
  
  static boolean isNewPorFieldBoundary(MJIEnv env, int updaterRef, int tRef) {
    ThreadInfo ti = env.getThreadInfo();
    
    // >2do> do we also have to check if the updater is shared?
    
    return !ti.isFirstStepInsn() && ti.usePorFieldBoundaries()
        && ti.hasOtherRunnables() && env.isSchedulingRelevantObject(tRef);
  }

  static boolean createAndSetFieldCG(MJIEnv env, int tRef) {
    ThreadInfo ti = env.getThreadInfo();
    ElementInfo ei = env.getElementInfo(tRef);
    SystemState ss = env.getSystemState();

    ChoiceGenerator<?> cg = ss.getSchedulerFactory().createSharedFieldAccessCG(
        ei, ti);
    if (cg != null) {
      ss.setNextChoiceGenerator(cg);
      env.repeatInvocation();
      return true;
    }

    return false;
  }

}
