/*
 * Copyright 2007, SDQ, IPD, University of Karlsruhe
 */
package de.uka.ipd.sdq.pcm.gmf.usage.edit.parts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import de.uka.ipd.sdq.pcm.gmf.usage.edit.policies.DelayItemSemanticEditPolicy;
import de.uka.ipd.sdq.pcm.gmf.usage.part.PalladioComponentModelVisualIDRegistry;
import de.uka.ipd.sdq.pcm.gmf.usage.providers.PalladioComponentModelElementTypes;

/**
 * @generated
 */
public class DelayEditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 3017;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public DelayEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new DelayItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		UsageDelayFigure figure = new UsageDelayFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public UsageDelayFigure getPrimaryShape() {
		return (UsageDelayFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof DelayEntityNameEditPart) {
			((DelayEntityNameEditPart) childEditPart)
					.setLabel(getPrimaryShape().getFigureUsageDelayNameLabel());
			return true;
		}
		if (childEditPart instanceof DelayLabelSpecEditPart) {
			((DelayLabelSpecEditPart) childEditPart).setLabel(getPrimaryShape()
					.getFigureUsageDelaySpecLabel());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof DelayEntityNameEditPart) {
			return true;
		}
		if (childEditPart instanceof DelayLabelSpecEditPart) {
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(PalladioComponentModelVisualIDRegistry
				.getType(DelayEntityNameEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSource() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types
				.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSourceAndTarget(
			IGraphicalEditPart targetEditPart) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (targetEditPart instanceof StartEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		if (targetEditPart instanceof StopEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		if (targetEditPart instanceof EntryLevelSystemCallEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		if (targetEditPart instanceof LoopEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		if (targetEditPart instanceof BranchEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		if (targetEditPart instanceof de.uka.ipd.sdq.pcm.gmf.usage.edit.parts.DelayEditPart) {
			types
					.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForTarget(
			IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Start_3001);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Stop_3002);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types
					.add(PalladioComponentModelElementTypes.EntryLevelSystemCall_3003);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Loop_3005);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Branch_3008);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Delay_3017);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnTarget() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types
				.add(PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForSource(
			IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Start_3001);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Stop_3002);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types
					.add(PalladioComponentModelElementTypes.EntryLevelSystemCall_3003);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Loop_3005);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Branch_3008);
		}
		if (relationshipType == PalladioComponentModelElementTypes.AbstractUserActionSuccessor_4002) {
			types.add(PalladioComponentModelElementTypes.Delay_3017);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public class UsageDelayFigure extends RoundedRectangle {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureUsageDelaySpecLabel;
		/**
		 * @generated
		 */
		private WrappingLabel fFigureUsageDelayNameLabel;

		/**
		 * @generated
		 */
		public UsageDelayFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			this.setLayoutManager(layoutThis);

			this.setCornerDimensions(new Dimension(getMapMode().DPtoLP(8),
					getMapMode().DPtoLP(8)));
			this.setLineWidth(1);
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			WrappingLabel usageDelayStereotypeLabel0 = new WrappingLabel();
			usageDelayStereotypeLabel0.setText("<<UsageDelay>>");

			this.add(usageDelayStereotypeLabel0);

			fFigureUsageDelayNameLabel = new WrappingLabel();
			fFigureUsageDelayNameLabel.setText("");

			this.add(fFigureUsageDelayNameLabel);

			fFigureUsageDelaySpecLabel = new WrappingLabel();
			fFigureUsageDelaySpecLabel.setText("");

			GridData constraintFFigureUsageDelaySpecLabel = new GridData();
			constraintFFigureUsageDelaySpecLabel.verticalAlignment = GridData.END;
			constraintFFigureUsageDelaySpecLabel.horizontalAlignment = GridData.CENTER;
			constraintFFigureUsageDelaySpecLabel.horizontalIndent = 0;
			constraintFFigureUsageDelaySpecLabel.horizontalSpan = 1;
			constraintFFigureUsageDelaySpecLabel.verticalSpan = 1;
			constraintFFigureUsageDelaySpecLabel.grabExcessHorizontalSpace = true;
			constraintFFigureUsageDelaySpecLabel.grabExcessVerticalSpace = false;
			this.add(fFigureUsageDelaySpecLabel,
					constraintFFigureUsageDelaySpecLabel);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureUsageDelaySpecLabel() {
			return fFigureUsageDelaySpecLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureUsageDelayNameLabel() {
			return fFigureUsageDelayNameLabel;
		}

	}

}
