/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.ltsa.NondetermisticAutomaton;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedAlternative;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedParallel;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedParallelOr;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedProvisionNode;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedProvisionNull;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedProvisionSequence;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedRepetition;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedAcceptRequest;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmitResponse;

/**
 * Compiles provision into LTS.
 * 
 * @author caitt3am
 *
 */
public class TranslateProvisionVisitor extends 
	CheckingVisitor<NondetermisticAutomaton> {

	 @Override
	public NondetermisticAutomaton visitResolvedProvisionContainerNode(
			TBPResolvedProvisionContainerNode resolvedContainer) {

		return ((TBPResolvedProvisionNode) resolvedContainer.getChild()).visit(this);
	}
	 
	@Override
	public NondetermisticAutomaton visitResolvedProvisionSequence(
			TBPResolvedProvisionSequence resolvedSequence) {

		TBPResolvedProvisionNode left = (TBPResolvedProvisionNode) resolvedSequence.getLeft();
		TBPResolvedProvisionNode right = (TBPResolvedProvisionNode) resolvedSequence.getRight();
		
		return left.visit(this).addSequence(right.visit(this));
	}
	
	@Override
	public NondetermisticAutomaton visitResolvedAlternative(
			TBPResolvedAlternative resolvedAlternative) {
		TBPResolvedProvisionNode left = (TBPResolvedProvisionNode) resolvedAlternative.getLeft();
		TBPResolvedProvisionNode right = (TBPResolvedProvisionNode) resolvedAlternative.getRight();
		return left.visit(this).addAlternative(right.visit(this));
	}
	
	
	@Override
	public NondetermisticAutomaton visitResolvedParallel(
			TBPResolvedParallel resolvedParallel) {
		TBPResolvedProvisionNode left = (TBPResolvedProvisionNode) resolvedParallel.getLeft();
		TBPResolvedProvisionNode right = (TBPResolvedProvisionNode) resolvedParallel.getRight();

		return left.visit(this).addParallel(right.visit(this));
	}

	@Override
	public NondetermisticAutomaton visitResolvedParallelOr(
			TBPResolvedParallelOr resolvedParallelOr) {
		TBPResolvedProvisionNode left = (TBPResolvedProvisionNode) resolvedParallelOr.getLeft();
		TBPResolvedProvisionNode right = (TBPResolvedProvisionNode) resolvedParallelOr.getRight();
		
		return left.visit(this).addParallelOr(right.visit(this));
	}
	
	
	@Override
	public NondetermisticAutomaton visitResolvedLimitedReentrancy(
			TBPResolvedLimitedReentrancy node) {
	
		TBPResolvedProvisionNode ch = (TBPResolvedProvisionNode) node.getChild();
		
		return ch.visit(this).addReentrancy(node.getLimit());
	}
	
	@Override
	public NondetermisticAutomaton visitResolvedRepetition(
			TBPResolvedRepetition resolvedRepetition) {

		TBPResolvedProvisionNode ch = (TBPResolvedProvisionNode) resolvedRepetition.getChild();
		return ch.visit(this).addRepetition();
	}
	
	@Override
	public NondetermisticAutomaton visitResolvedProvisionNull(
			TBPResolvedProvisionNull resolvedProvisionNull) {
	
		return NondetermisticAutomaton.createNull();
	}
	
	@Override
	public NondetermisticAutomaton visitResolvedAcceptRequest(
			TBPResolvedAcceptRequest resolvedAcceptRequest) {

		return NondetermisticAutomaton.createSimple(resolvedAcceptRequest.getEventIndex());
	}
	
	@Override
	public NondetermisticAutomaton visitResolvedEmitResponse(
			TBPResolvedEmitResponse resolvedEmitResponse) {

		return NondetermisticAutomaton.createSimple(resolvedEmitResponse.getEventIndex());
	}
}
