/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.resolved.ConstantRef;
import org.ow2.dsrg.fm.tbplib.resolved.FPRef;
import org.ow2.dsrg.fm.tbplib.resolved.Reference;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedCondition;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedIf;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedImperativeNode;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedImperativeNull;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedReturn;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedSwitch;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedValue;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedWhile;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmit;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;

public class SubstituteVisitor extends CopyVisitor {

	private final Binding binding;

	public SubstituteVisitor(Binding binding) {
		assert binding.isBound();
		this.binding = binding;
	}
	
	@Override
	public TBPResolvedImperativeNode visitResolvedSwitch(
			TBPResolvedSwitch resolvedSwitch) {
		
		// substitutes all descendants (incl. switching value)
		TBPResolvedSwitch s = (TBPResolvedSwitch) super.visitResolvedSwitch(resolvedSwitch);
		
		if(s.isNondeterministic()){
			return s;
		}
		
		Reference r = s.getValue().getReference();
		if(r != null && (r instanceof ConstantRef)){

			int i = s.getCases().indexOf(r);
			if(i == -1){
				if(s.getDefaultBranch() != null){
					i = s.getChildCount() - 1;
				} else {
					//TODO: what to do?
					return new TBPResolvedImperativeNull();
				}
			} else {
				// we need non-parented node --> remove instead of get
				return (TBPResolvedImperativeNode) s.removeChild(i);
			}
		}
		
		return s;
		
	}
	
	public TBPResolvedCondition substituteCondition(TBPResolvedCondition cond) {
		
		if(cond.isNondeterministic()){
			return cond;
		}
		
		Reference ref1 = changeReference(cond.getLeft());
		
		return new TBPResolvedCondition(ref1,cond.getRight());
	}
	
	@Override
	public TBPResolvedImperativeNode visitResolvedIf(TBPResolvedIf resolvedIf) {
		
		TBPResolvedImperativeNode ifb = (TBPResolvedImperativeNode) resolvedIf.getChild(0);
		TBPResolvedImperativeNode elseb = null;
		
		TBPResolvedCondition cond = substituteCondition(resolvedIf.getCondition());
		
		ifb = ifb.visit(this);
		if(resolvedIf.hasElse()){
			elseb = (TBPResolvedImperativeNode) resolvedIf.getChild(1);
			elseb = elseb.visit(this);
		}

		if(cond.isNondeterministic()){
			return new TBPResolvedIf(cond, ifb, elseb);
		}
		
		if(cond.getLeft().equals(cond.getRight())){
			return ifb;
		}
		
		if(cond.getLeft() instanceof ConstantRef){
			if(elseb != null)
				return elseb;
			else
				return new TBPResolvedImperativeNull();
		}
		
		return new TBPResolvedIf(cond, ifb, elseb);
	}
	
	
	@Override
	public TBPResolvedImperativeNode visitResolvedWhile(
			TBPResolvedWhile resolvedWhile) {
		TBPResolvedCondition cond = substituteCondition(resolvedWhile.getCondition());
		TBPResolvedImperativeNode code = (TBPResolvedImperativeNode) resolvedWhile.getChild();
		
		if(cond.isDeterministic() && !cond.getLeft().equals(cond.getRight())
				&& cond.getLeft() instanceof ConstantRef){
			return new TBPResolvedImperativeNull();
		}
		
		return new TBPResolvedWhile(cond, code.visit(this));
	}
	
	@Override
	public TBPResolvedImperativeNode visitResolvedEmit(
			TBPResolvedEmit resolvedEmit) {

		return new TBPResolvedEmit(
				resolvedEmit.getBinding().rebind(binding));
	}
	
	@Override
	public TBPResolvedImperativeNode visitResolvedReturn(
			TBPResolvedReturn resolvedReturn) {
		return super.visitResolvedReturn(resolvedReturn);
	}
	
	@Override
	public TBPResolvedImperativeNode visitResolvedValue(
			TBPResolvedValue resolvedValue) {
		
		if(resolvedValue.isReference()){
			return new TBPResolvedValue(changeReference(resolvedValue.getReference()));
		}

		return super.visitResolvedValue(resolvedValue);
	}
	
	public Reference changeReference(Reference ref){
		if (ref instanceof FPRef)  {
			return binding.getValue(ref.getName());
		}
		return ref;
	}	
	
}