/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.resolved.*;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedAcceptRequest;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmitResponse;

/**
 * This abstract visitor throws exception on provision nodes. Extends this
 * if you need visitor that works on trees of imperative nodes.
 * It works on all {@link TBPResolvedImperativeNode} nodes with the exception of
 * {@link TBPResolvedMethodDefinition}
 * 
 * @author caitt3am
 *
 */
public abstract class ImperativeVisitor<E> implements TBPResolvedVisitor<E> {
	

	private static TBPResolvingException exc = 
		new TBPResolvingException("This visitor works only on imperative nodes");
	
	@Override
	public E visitResolvedAcceptRequest(TBPResolvedAcceptRequest resolvedAcceptRequest) {
		throw exc;
	}

	@Override
	public E visitResolvedAlternative(
			TBPResolvedAlternative resolvedAlternative) {
		throw exc;
	}

	@Override
	public E visitResolvedEmitResponse(
			TBPResolvedEmitResponse resolvedEmitResponse) {
		throw exc;
	}


	@Override
	public E visitResolvedLimitedReentrancy(
			TBPResolvedLimitedReentrancy node) {
		throw exc;
	}

	@Override
	public E visitResolvedMethodDeclaration(
			TBPResolvedMethodDefinition resolvedMethodDeclaration) {
		throw exc;
	}

	@Override
	public E visitResolvedParallel(TBPResolvedParallel resolvedParallel) {
		 throw exc;
	}

	@Override
	public E visitResolvedParallelOr(
			TBPResolvedParallelOr resolvedParallelOr) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionBinaryNode(
			TBPResolvedProvisionBinaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionContainerNode(
			TBPResolvedProvisionContainerNode resolvedProvisionContainerNode) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionLeafNode(
			TBPResolvedProvisionLeafNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionNaryNode(
			TBPResolvedProvisionNaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionNull(
			TBPResolvedProvisionNull resolvedProvisionNull) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionUnaryNode(
			TBPResolvedProvisionUnaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedRepetition(
			TBPResolvedRepetition resolvedRepetition) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionSequence(TBPResolvedProvisionSequence resolvedSequence) {
		throw exc;
	}

}
