/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.resolved.*;
import org.ow2.dsrg.fm.tbplib.resolved.events.*;

/**
 * @author caitt3am
 *
 */
public class CheckingVisitor<E> implements TBPResolvedVisitor<E> {

	private static RuntimeException exc = 
		new RuntimeException("Unexpected type of node ");
	
	@Override
	public E visitResolvedAcceptRequest(
			TBPResolvedAcceptRequest resolvedAcceptRequest) {
		throw exc;
	}

	@Override
	public E visitResolvedAlternative(
			TBPResolvedAlternative resolvedAlternative) {
		throw exc;
	}

	@Override
	public E visitResolvedAssignment(
			TBPResolvedAssignment resolvedAssignment) {
		throw exc;
	}


	@Override
	public E visitResolvedEmitResponse(
			TBPResolvedEmitResponse resolvedEmitResponse) {
		throw exc;
	}

	@Override
	public E visitResolvedIf(TBPResolvedIf resolvedIf) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeBinaryNode(
			TBPResolvedImperativeBinaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeLeafNode(
			TBPResolvedImperativeLeafNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeNaryNode(
			TBPResolvedImperativeNaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeNull(
			TBPResolvedImperativeNull resolvedImperativeNull) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeSequence(
			TBPResolvedImperativeSequence resolvedImperativeSequence) {
		throw exc;
	}

	@Override
	public E visitResolvedImperativeUnaryNode(
			TBPResolvedImperativeUnaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedLimitedReentrancy(
			TBPResolvedLimitedReentrancy node) {
		throw exc;
	}

	@Override
	public E visitResolvedMethodDeclaration(
			TBPResolvedMethodDefinition resolvedMethodDeclaration) {
		throw exc;
	}

	@Override
	public E visitResolvedParallel(TBPResolvedParallel resolvedParallel) {
		throw exc;
	}

	@Override
	public E visitResolvedParallelOr(
			TBPResolvedParallelOr resolvedParallelOr) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionBinaryNode(
			TBPResolvedProvisionBinaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionContainerNode(
			TBPResolvedProvisionContainerNode resolvedContainer) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionLeafNode(
			TBPResolvedProvisionLeafNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionNaryNode(
			TBPResolvedProvisionNaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionNull(
			TBPResolvedProvisionNull resolvedProvisionNull) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionSequence(
			TBPResolvedProvisionSequence resolvedSequence) {
		throw exc;
	}

	@Override
	public E visitResolvedProvisionUnaryNode(
			TBPResolvedProvisionUnaryNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedRepetition(
			TBPResolvedRepetition resolvedRepetition) {
		throw exc;
	}

	@Override
	public E visitResolvedReturn(TBPResolvedReturn resolvedReturn) {
		throw exc;
	}

	@Override
	public E visitResolvedSwitch(TBPResolvedSwitch resolvedSwitch) {
		throw exc;
	}

	@Override
	public E visitResolvedSync(TBPResolvedSync resolvedSync) {
		throw exc;
	}

	@Override
	public E visitResolvedEmit(TBPResolvedEmit resolvedEmit) {
		throw exc;
	}

	@Override
	public E visitResolvedValue(TBPResolvedValue resolvedValue) {
		throw exc;
	}

	@Override
	public E visitResolvedWhile(TBPResolvedWhile resolvedWhile) {
		throw exc;
	}

	@Override
	public E visitResolvedMangledReaction(TBPResolvedMangledReaction node) {
		throw exc;
	}

	@Override
	public E visitResolvedThreadContainerNode(
			TBPResolvedThreadContainerNode node) {
		throw exc;
	}

	@Override
	public E visitResolvedUndefinedEmit(TBPResolvedUndefinedEmit resolvedEmit) {
		throw exc;
	}

}
