/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.TBPNode;
import org.ow2.dsrg.fm.tbplib.resolved.*;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmit;

/**
 * This visitor checks if all path contains return.
 * It is quite conservative.
 *  
 * @author caitt3am
 *
 */
public class CheckReturnsVisitor extends ImperativeVisitor<Boolean> {

	@Override
	public Boolean visitResolvedAssignment(
			TBPResolvedAssignment resolvedAssignment) {
		return Boolean.FALSE;
	}

	@Override
	public Boolean visitResolvedEmit(TBPResolvedEmit resolvedEmit) {
		return Boolean.FALSE;
	}

	@Override
	public Boolean visitResolvedUndefinedEmit(
			TBPResolvedUndefinedEmit resolvedEmit) {
		return Boolean.FALSE;
	}
	
	@Override
	public Boolean visitResolvedIf(TBPResolvedIf resolvedIf) {

		if(!resolvedIf.hasElse()){
			return Boolean.FALSE;
		}
		
		TBPResolvedImperativeNode code  = (TBPResolvedImperativeNode) resolvedIf.getChild(0);
		TBPResolvedImperativeNode code2 = (TBPResolvedImperativeNode) resolvedIf.getChild(1);

		return code.visit(this) && code2.visit(this);
	}

	@Override
	public Boolean visitResolvedImperativeBinaryNode(
			TBPResolvedImperativeBinaryNode node) {
		return null;
	}

	@Override
	public Boolean visitResolvedImperativeLeafNode(
			TBPResolvedImperativeLeafNode node) {
		return null;
	}

	@Override
	public Boolean visitResolvedImperativeNaryNode(
			TBPResolvedImperativeNaryNode node) {
		return null;
	}

	@Override
	public Boolean visitResolvedImperativeNull(
			TBPResolvedImperativeNull resolvedImperativeNull) {
		return Boolean.FALSE;
	}

	@Override
	public Boolean visitResolvedImperativeSequence(
			TBPResolvedImperativeSequence resolvedImperativeSequence) {
		TBPResolvedImperativeNode left = (TBPResolvedImperativeNode) resolvedImperativeSequence.getLeft();
		TBPResolvedImperativeNode right = (TBPResolvedImperativeNode) resolvedImperativeSequence.getRight();
		
		return left.visit(this) || right.visit(this);
	}

	@Override
	public Boolean visitResolvedImperativeUnaryNode(
			TBPResolvedImperativeUnaryNode node) {
		return null;
	}

	@Override
	public Boolean visitResolvedMangledReaction(TBPResolvedMangledReaction node) {
		TBPResolvedImperativeNode code = (TBPResolvedImperativeNode) node.getChild();
		return code.visit(this);
	}

	@Override
	public Boolean visitResolvedReturn(TBPResolvedReturn resolvedReturn) {
		return Boolean.TRUE;
	}

	@Override
	public Boolean visitResolvedSwitch(TBPResolvedSwitch resolvedSwitch) {
		for (TBPNode node : resolvedSwitch.getChildren()) {
			TBPResolvedImperativeNode code = (TBPResolvedImperativeNode) node;
			if(code.visit(this).equals(Boolean.FALSE))
				return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}

	@Override
	public Boolean visitResolvedSync(TBPResolvedSync resolvedSync) {
		TBPResolvedImperativeNode code = (TBPResolvedImperativeNode) resolvedSync.getChild();
		return code.visit(this);
	}

	@Override
	public Boolean visitResolvedThreadContainerNode(
			TBPResolvedThreadContainerNode node) {
		TBPResolvedImperativeNode code = (TBPResolvedImperativeNode) node.getChild();
		return code.visit(this);
	}

	@Override
	public Boolean visitResolvedValue(TBPResolvedValue resolvedValue) {
		return Boolean.FALSE;
	}

	@Override
	public Boolean visitResolvedWhile(TBPResolvedWhile resolvedWhile) {	
		return Boolean.FALSE;
	}

}
