/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved;

import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmit;
import org.ow2.dsrg.fm.tbplib.resolved.visitor.TBPResolvedVisitor;
import org.ow2.dsrg.fm.tbplib.util.Typedef;


/**
 * In TBP there are two kinds of values: references and method calls. This class
 * represents both of them.
 *  
 * @author caitt3am
 *
 */
public class TBPResolvedValue extends TBPResolvedImperativeNaryNode {

	private final Reference reference;
	
	public TBPResolvedValue(Reference varname) {
		this.reference = varname;
	}
	
	public TBPResolvedValue(TBPResolvedEmit emit) {
		if(emit.getBinding().getMethodSignature().getReturnType() == null){
			throw new TBPResolvingException("Cannot use call to procedure as a value");
		}
		addChild(emit);
		this.reference = null;
	}
	
	public Reference getReference() {
		return reference;
	}
	
	public TBPResolvedEmit getMethodCall() {
		if(isReference())
			return null;
		return (TBPResolvedEmit) getChild(0);
	}
	
	public boolean isReference() {
		return reference != null;
	}
	
	public boolean isMethodCall() {
		return !isReference();
	}

	public Typedef getType() {
		if(isReference()){
			return reference.getType();
		} else {
			return getMethodCall().getBinding().getMethodSignature().getReturnType();
		}
	}
	@Override
	public <E> E visit(TBPResolvedVisitor<E> visitor) {
		return visitor.visitResolvedValue(this);
	}
	
	@Override
	public String toString() {
		if(isReference()){
			return reference.getName();
		} else {
			return getMethodCall().toString();
		}
			
	}
}
