/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved;

import org.ow2.dsrg.fm.tbplib.resolved.visitor.TBPResolvedVisitor;


/**
 * Top most node of provision section. Hold tree for individual provision.
 * 
 * @author caitt3am
 *
 */
public class TBPResolvedProvisionContainerNode extends
		TBPResolvedProvisionUnaryNode {

	private String name;
	
	public TBPResolvedProvisionContainerNode(TBPResolvedProvisionNode provisionTree, String name) {
		super(provisionTree);
		this.name = name;
	}
	
	public String getName() {
		return name;
	}

	@Override
	public <E> E visit(TBPResolvedVisitor<E> a) {
		return a.visitResolvedProvisionContainerNode(this);
	}

}
