/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved;

import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;
import org.ow2.dsrg.fm.tbplib.resolved.visitor.TBPResolvedVisitor;

/**
 * Reaction with of formal parameters substituted.
 * 
 * @author caitt3am
 *
 */
public class TBPResolvedMangledReaction extends TBPResolvedImperativeUnaryNode {

	private final Binding binding;

	public TBPResolvedMangledReaction(Binding ms, TBPResolvedImperativeNode code){
		super(code);
		this.binding = ms;
	}
	
	public Binding getBinding() {
		return binding;
	}
	
	/**
	 * Full name of original definition.
	 * @return
	 */
	public String getName(){
		return binding.getMethodSignature().getFullname();
	}
	
	/**
	 * Append string of substituted values to the name of original definition.
	 * @return Name of reactions with mangled parameters.
	 */
	public String getMangledName(){
		StringBuilder sb = new StringBuilder();
		sb.append(getName());
		for(String p_name : binding.getMethodSignature().getParamNames()){
			sb.append(":");
			sb.append(binding.getValue(p_name).getName());
		}
		return sb.toString();
	}
	
	@Override
	public <E> E visit(TBPResolvedVisitor<E> a) {
		return a.visitResolvedMangledReaction(this);
	}

}
