/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.ow2.dsrg.fm.tbplib.parsed.ParsedComponentSpecification;

/**
 * 
 * Helper class that facilitates parsing TBP files and 
 * hides interaction with ANTLR.
 * 
 * @author caitt3am
 *
 */
public class ParserFacade {

	public static ParsedComponentSpecification parseFile(String filename) throws IOException, RecognitionException{
			return parseFile(new FileInputStream(filename));
	}
	
	public static ParsedComponentSpecification parseFile(File file) throws IOException, RecognitionException{
			return parseFile(new FileInputStream(file));
	}
	
	public static ParsedComponentSpecification parseFile(InputStream stream) 
		throws IOException, RecognitionException {
		try {
			ANTLRInputStream input = new ANTLRInputStream(stream);
	        TBPLexer lexer = new TBPLexer(input);
	        CommonTokenStream tokens = new CommonTokenStream(lexer);
	        TBPParser parser = new TBPParser(tokens);
	        CommonTree t  = (CommonTree) parser.tbp().getTree();
	        
	        CommonTreeNodeStream nodes = new CommonTreeNodeStream(t);
	        TBPTree evaluator = new TBPTree(nodes);
	        ParsedComponentSpecification component = evaluator.component();
	    
	        return component;
		}catch (RuntimeException e){
			throw new RecognitionException();
		}
	}
}
