package org.ow2.dsrg.fm.tbplib.parsed.visitor;

import org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAssignment;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedEmit;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedIf;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedReturn;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSwitch;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSync;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedValue;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedWhile;
import org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy;

/**
 * Implementation of {@link TBPParsedVisitor} that does nothing.
 * 
 * @author caitt3am
 *
 * @param <E> Type returned by visit methods, if not overriden they will
 * return <code>null</code>.
 */
public class TBPParsedDefaultVisitor<E> implements TBPParsedVisitor<E> {

	@Override
	public E visitParsedImperativeBinaryNode(TBPParsedImperativeBinaryNode node) {
		return null;
	}
	
	@Override
	public E visitParsedImperativeNaryNode(TBPParsedImperativeNaryNode node) {
		return null;
	}
	
	@Override
	public E visitParsedImperativeLeafNode(TBPParsedImperativeLeafNode node) {
		return null;
	}
	
	@Override
	public E visitParsedImperativeUnaryNode(TBPParsedImperativeUnaryNode node){
		return null;
	}
	
	@Override
	public E visitParsedProvisionBinaryNode(TBPParsedProvisionBinaryNode node) {
		return null;
	}
	
	@Override
	public E visitParsedProvisionNaryNode(TBPParsedProvisionNaryNode node) {
		return null;
	}
	
	@Override
	public E visitParsedProvisionLeafNode(TBPParsedProvisionLeafNode node) {
		return null;
	}
	
	@Override
	public E visitParsedImperativeSequence(TBPParsedImperativeSequence node) {
		return null;
	}
	
	@Override
	public E visitParsedSwitch(TBPParsedSwitch node) {
		return null;
	}
	
	@Override
	public E visitParsedIf(TBPParsedIf node) {
		return null;
	}
	
	@Override
	public E visitParsedValue(TBPParsedValue node) {
		return null;
	}
	
	@Override
	public E visitParsedReturn(TBPParsedReturn node) {
		return null;
	}
	
	@Override
	public E visitParsedWhile(TBPParsedWhile node){
		return null;
	}
	
	@Override
	public E visitParsedAssignment(TBPParsedAssignment node){
		return null;
	}
	
	@Override
	public E visitParsedMethodDeclaration(TBPParsedMethodDeclaration node){
		return null;
	}
	
	@Override
	public E visitParsedSync(TBPParsedSync node){
		return null;
	}
	
	@Override
	public E visitParsedImperativeNull(TBPParsedImperativeNull node){
		return null;
	}
	
	@Override
	public E visitParsedEmit(TBPParsedEmit node){
		return null;
	}
	
	@Override
	public E visitParsedAlternative(TBPParsedAlternative node) {
		return null;
	}
	
	@Override
	public E visitParsedParallel(TBPParsedParallel  node) {
		return null;
	}
	
	@Override
	public E visitParsedParallelOr(TBPParsedParallelOr node) {
		return null;
	}
	
	@Override
	public E visitParsedSequence(TBPParsedSequence node) {
		return null;
	}
	
	@Override
	public E visitParsedAccept(TBPParsedAccept node) {
		return null;
	}
	
	@Override
	public E visitParsedNull(TBPParsedProvisionNull node) {
		return null;
	}
	
	@Override
	public E visitLimitedReentrancy(TBPLimitedReentrancy node) {
		return null;
	}
	
	@Override
	public E visitParsedRepetition(TBPParsedRepetition node) {
		return null;
	}
	
	@Override
	public E visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) {
		return null;
	}

	@Override
	public E visitParsedProvisionUnaryNode(TBPParsedProvisionUnaryNode 
			parsedProvisionUnaryNode) {
		return null;
	}

	@Override
	public E visitParsedProvisionContainerNode(
			TBPParsedProvisionContainerNode parsedProvisionContainerNode) {
		return null;
	}

	@Override
	public E visitParsedThreadContainerNode(TBPParsedThreadContainerNode node) {
		return null;
	}

}
