/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed.visitor;

import org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAssignment;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedEmit;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedIf;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedReturn;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSwitch;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSync;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedValue;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedWhile;
import org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy;

/**
 * Visitor that throws exception on every node.
 * Extend this to check for omitted cases.
 * 
 * @author caitt3am
 *
 */
public class TBPParsedCheckingVisitor<E> implements TBPParsedVisitor<E> {

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitLimitedReentrancy(org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy)
	 */
	@Override
	public E visitLimitedReentrancy(TBPLimitedReentrancy node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedAlternative(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative)
	 */
	@Override
	public E visitParsedAlternative(TBPParsedAlternative node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedAssignment(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAssignment)
	 */
	@Override
	public E visitParsedAssignment(TBPParsedAssignment node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedIf(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedIf)
	 */
	@Override
	public E visitParsedIf(TBPParsedIf node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeBinaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeBinaryNode)
	 */
	@Override
	public E visitParsedImperativeBinaryNode(
			TBPParsedImperativeBinaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeLeafNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeLeafNode)
	 */
	@Override
	public E visitParsedImperativeLeafNode(TBPParsedImperativeLeafNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeMethodCall(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeMethodCall)
	 */
	@Override
	public E visitParsedEmit(
			TBPParsedEmit node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeNaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNaryNode)
	 */
	@Override
	public E visitParsedImperativeNaryNode(TBPParsedImperativeNaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeNull(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNull)
	 */
	@Override
	public E visitParsedImperativeNull(TBPParsedImperativeNull node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeSequence(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeSequence)
	 */
	@Override
	public E visitParsedImperativeSequence(TBPParsedImperativeSequence node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedImperativeUnaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeUnaryNode)
	 */
	@Override
	public E visitParsedImperativeUnaryNode(
			TBPParsedImperativeUnaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedMethodDeclaration(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedMethodDeclaration)
	 */
	@Override
	public E visitParsedMethodDeclaration(TBPParsedMethodDeclaration node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedNull(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull)
	 */
	@Override
	public E visitParsedNull(TBPParsedProvisionNull node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedParallel(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel)
	 */
	@Override
	public E visitParsedParallel(TBPParsedParallel node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedParallelOr(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr)
	 */
	@Override
	public E visitParsedParallelOr(TBPParsedParallelOr node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionBinaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionBinaryNode)
	 */
	@Override
	public E visitParsedProvisionBinaryNode(
			TBPParsedProvisionBinaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionContainerNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode)
	 */
	@Override
	public E visitParsedProvisionContainerNode(
			TBPParsedProvisionContainerNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionLeafNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionLeafNode)
	 */
	@Override
	public E visitParsedProvisionLeafNode(TBPParsedProvisionLeafNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionMethodCall(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionMethodCall)
	 */
	@Override
	public E visitParsedAccept(
			TBPParsedAccept node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionNaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNaryNode)
	 */
	@Override
	public E visitParsedProvisionNaryNode(TBPParsedProvisionNaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedProvisionUnaryNode(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionUnaryNode)
	 */
	@Override
	public E visitParsedProvisionUnaryNode(
			TBPParsedProvisionUnaryNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedRepetition(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition)
	 */
	@Override
	public E visitParsedRepetition(TBPParsedRepetition node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedthrow(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedthrow)
	 */
	@Override
	public E visitParsedReturn(TBPParsedReturn node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedSequence(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence)
	 */
	@Override
	public E visitParsedSequence(TBPParsedSequence node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedSwitch(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSwitch)
	 */
	@Override
	public E visitParsedSwitch(TBPParsedSwitch node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedSync(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSync)
	 */
	@Override
	public E visitParsedSync(TBPParsedSync node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedValue(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedValue)
	 */
	@Override
	public E visitParsedValue(TBPParsedValue node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitParsedWhile(org.ow2.dsrg.fm.tbplib.parsed.TBPParsedWhile)
	 */
	@Override
	public E visitParsedWhile(TBPParsedWhile node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
		
	}

	/* (non-Javadoc)
	 * @see org.ow2.dsrg.fm.tbplib.parsed.TBPParsedVisitor#visitUnlimitedReentrancy(org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy)
	 */
	@Override
	public E visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());		
	}

	@Override
	public E visitParsedThreadContainerNode(TBPParsedThreadContainerNode node) {
		throw new RuntimeException("Unexpected type of node: " + node.getClass());
	}

}
