/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.util.*;

import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedVardef;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;
import org.ow2.dsrg.fm.tbplib.util.Typedef;

/**
 * Envelope around automatons for one component.
 * 
 * @author caitt3am
 *
 */
public class LTSAComponentSpecification {
	
	private final String name;
	private final List<Typedef> types;
	private final Map<String, TBPResolvedVardef> vardefs;
	//private final Map<String, DeterministicAutomaton> provisions;
	private final Map<String, NondetermisticAutomaton> provisions;
	private final Map<String, LTSAAutomaton> threads;
	private final Map<Binding, LTSAAutomaton> reactions;
	private final Map<Binding, LTSAAutomaton> inlined_reactions;
	
	public LTSAComponentSpecification(String componentname,
		    List<Typedef>  types,  
		    Map<String, TBPResolvedVardef> vardefs,
//		    Map<String, DeterministicAutomaton> provisions,
		    Map<String, NondetermisticAutomaton> provisions,
		    Map<String, LTSAAutomaton> threads,
		    Map<Binding, LTSAAutomaton> reactions){
		    
		this.name = componentname;
		this.types = types;
		this.vardefs = vardefs;
		this.provisions = provisions;
		this.reactions = reactions;
		this.threads = threads;
		
		inlined_reactions = new HashMap<Binding, LTSAAutomaton>(reactions.size());
    }
    
	public String getName() {
		return name;
	}
	
//	public Map<String, DeterministicAutomaton> getProvisions() {
	public Map<String, NondetermisticAutomaton> getProvisions() {
		return provisions;
	}
	
	public void inlineAllThreads() {
		
		for(LTSAAutomaton a : threads.values()){
			inlineAllEmits(a);
		}
	}
	
	/**
	 * Takes rid off all emits in given automaton. 
	 * 
	 * @param a What automaton to inline
	 * @return automaton without emits
	 */
	private void inlineAllEmits(LTSAAutomaton a) {
		List<Edge> emits = Utils.findEmits(a.getStart());
		for(Edge e: emits){
			Utils.inlineEmit(e, reactions, inlined_reactions);
		}
		assert Utils.findEmits(a.getStart()).size() == 0;
	}

	public List<Typedef> getTypes() {
		return types;
	}

	public Map<String, TBPResolvedVardef> getVardefs() {
		return vardefs;
	}

	public Map<String, LTSAAutomaton> getThreads() {
		return threads;
	}

	public Map<Binding, LTSAAutomaton> getReactions() {
		return reactions;
	}
}
