/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.impl;

import java.util.Collections;
import java.util.List;

import org.ow2.dsrg.fm.tbplib.TBPNode;
import org.ow2.dsrg.fm.tbplib.UnaryNode;

/**
 * Node with just one child.
 * 
 * @author caitt3am
 *
 */
public class TBPUnaryNodeImpl extends TBPBoundedNodeImpl 
	implements UnaryNode {

	TBPNode child;
	public TBPUnaryNodeImpl(TBPNode child) {
		parentChild(child);
		this.child = child;
	}
	
	@Override
	public TBPNode getChild() {
		return child;
	}

	@Override
	public void setChild(TBPNode child) {
		parentChild(child);
		this.child.setParent(null);
		this.child = child;
	}

	@Override
	public TBPNode getChild(int index) {
		if(index == 0)
			return child;
		else 
			throw new IndexOutOfBoundsException();
	}

	@Override
	public int getChildCount() {
		return 1;
	}

	@Override
	public List<TBPNode> getChildren() {
		return Collections.singletonList(child);
	}

	@Override
	public void setChild(int index, TBPNode childNode) {
		if(index == 0)
			setChild(childNode);
		else 
			throw new IndexOutOfBoundsException();
	}

}
