package org.ow2.dsrg.fm.tbplib.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.ow2.dsrg.fm.tbplib.TBPNode;

/**
 * Iterates through nodes of given subtree in preorder.
 *  
 * @author caitt3am
 *
 */
class TBPNodeIterator implements Iterator<TBPNode> {
	TBPNode next; 
	
	// Each integer is an index of child that should be visited when backtracking to node (parent)
	Deque<Integer> stack = new ArrayDeque<Integer>();
	
	public TBPNodeIterator(TBPNode start) {
		this.next = start;
	}
	
	@Override
	public boolean hasNext() {
		return next != null;
	}

	@Override
	public TBPNode next() {
		if(!hasNext())
			throw new NoSuchElementException();
		
		TBPNode result = next;
		
		if(next.getChildCount() > 0){
			
			next = next.getChild(0);
			stack.push(1);
			
		} else {
			
			while(!stack.isEmpty()){
				
				int idx = stack.pop().intValue();
				next = next.getParent();
				
				if(next.getChildCount() > idx){
					next = next.getChild(idx);
					stack.push(idx+1);
					break;
				}
			}
			
			if(stack.isEmpty())
				next = null;
		}
		
		return result;
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
}