/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.ow2.dsrg.fm.tbplib.NaryNode;
import org.ow2.dsrg.fm.tbplib.TBPNode;

/**
 * @author caitt3am
 *
 */
public class TBPNaryNodeImpl extends TBPNodeImpl implements NaryNode {

	private List<TBPNode> list = new ArrayList<TBPNode>();

	@Override
	public void addFirstChild(TBPNode child) {
		insertChild(0, child);
	}

	@Override
	public void addLastChild(TBPNode child) {
		addChild(child);
	}

	@Override
	public void addChild(TBPNode childNode) {
		insertChild(list.size(), childNode);
	}

	@Override
	public int getChildCount() {
		return list.size();
	}

	@Override
	public TBPNode getChild(int index) {
		return list.get(index);
	}

	@Override
	public List<TBPNode> getChildren() {
		return Collections.unmodifiableList(list);
	}

	@Override
	public void insertChild(int index, TBPNode childNode) {
		if(index > list.size())
			throw new IndexOutOfBoundsException();
		parentChild(childNode);
		list.add(index,childNode);
	}

	@Override
	public TBPNode removeChild(int index) {
		TBPNode child = list.remove(index); 
		assert child.getParent() == this;
		child.setParent(null);
		return child;
	}

	@Override
	public void setChild(int index, TBPNode childNode) {
		if(index >= list.size())
			throw new IndexOutOfBoundsException();
		parentChild(childNode);
		list.get(index).setParent(null);
		list.set(index,childNode);
	}

}
