/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */

package org.ow2.dsrg.fm.tbplib.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.ow2.dsrg.fm.tbplib.BinaryNode;
import org.ow2.dsrg.fm.tbplib.TBPNode;

public class TBPBinaryNodeImpl extends TBPBoundedNodeImpl implements BinaryNode {

	private List<TBPNode> childs = new ArrayList<TBPNode>(2);
	
	public TBPBinaryNodeImpl(TBPNode left, TBPNode right) {
		parentChild(left);
		childs.add(left);
		
		parentChild(right);
		childs.add(right);
	}
	
	@Override
	public TBPNode getLeft() {
		return getChild(0);
	}

	@Override
	public TBPNode getRight() {
		return getChild(1);
	}

	@Override
	public void setLeft(TBPNode n) {
		setChild(0, n);
	}

	@Override
	public void setRight(TBPNode n) {
		setChild(1, n);
	}

	@Override
	public TBPNode getChild(int index) {
		return childs.get(index);
	}

	@Override
	public int getChildCount() {
		return childs.size();
	}

	@Override
	public List<TBPNode> getChildren() {
		return Collections.unmodifiableList(childs);
	}

	@Override
	public void setChild(int index, TBPNode childNode) {
		if(index >= 2) // extra check to avoid non-consistent tree after index overflow
			throw new IndexOutOfBoundsException();
		parentChild(childNode);
		childs.get(index).setParent(null);
		childs.set(index, childNode);
	}	
	
}
