/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib;

import java.util.List;


/**
 * 
 * Common interface to all nodes in TBP library. Supports traversing 
 * general tree in all directions.
 *   
 * @author caitt3am
 *
 */
public interface TBPNode extends Iterable<TBPNode> {
	
	/**
	 * Return parent - null if this is root.
	 */
	TBPNode   getParent();
	
	/**
	 * Sets parent of this node. Should not be used directly, use remove/set child instead. 
	 */
	void setParent(TBPNode parent);
	
	/**
	 * Return collection of children.
	 */
	List<TBPNode> getChildren();

	/**
	 * How many children has this node? 
	 */
	int getChildCount();
	
	/**
	 * Removes the child at the specified position. 
	 * @param index - the index of the element to removed.
	 * @throws IndexOutOfBoundsException - if index is out of range.
	 * @return removed child.
	 */
	TBPNode removeChild(int index);
	
	/** 
	 * Make node last child of this node. 
	 * @param childNode
	 */
	void addChild(TBPNode childNode);
	
	/**
	 * Inserts node into list of children.
	 * @param index - where to put childNode
	 * @param childNode - node to be inserted
	 * @throws IndexOutOfBoundsException - if the specified index is out of range.
	 */
	void insertChild(int index, TBPNode childNode);
	
	/**
	 * Replaces child at given index.
	 * @throws IndexOutOfBoundsException - if the specified index is out of range.
	 */
	void setChild(int index, TBPNode childNode);
	
	/**
	 * Returns child at given index.
	 * @throws IndexOutOfBoundsException - if the specified index is out of range (index < 0 || index >= size()).
	 */
	TBPNode getChild(int index);
	
	/**
	 * Returns annotation, null if it is not annotated (or can't be).
	 */
	Annotation getAnnotation();
	
	/**
	 * Sets annotation.
	 */
	void setAnnotation(Annotation annotation);
	
}
