/* $Id: ViolationOfNamingConventionCPP.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

/*
  left outer join TSourceEntities srcEnt on (meSuperClass .id = srcEnt.id) left outer join
  TFile files on (srcEnt.sourceFileIf = file.id)

*/
/* Verzeichnisse */

SELECT DISTINCT
	'DIRECTORY' AS type_of_element,
        '' as package_fullname,
        '' as class_fullname,
	a.name as element_name,
        '' as file_name,
        0 as line_number
   
FROM
	TAbstractions a
WHERE
	a.name NOT SIMILAR TO '[a-zA-Z][a-zA-Z0-9\\_]*'


UNION


/* Klassen und Interface */
SELECT DISTINCT	

	'CLASS' AS type_of_element,
        p.fullname as package_fullname,
        '' as class_fullname,
	c.fullname as element_name,
        f.pathname as file_name,
        se.startLine as line_number

FROM
	TTypes c,
	TPackages p,
	TConstants tc,
	TSourceEntities se,
	TModelElements mc,
	TConstants cmc,
        TFiles f
WHERE
	mc.id = c.id
	AND mc.status = cmc.value
	AND cmc.name = 'STATUS_NORMAL'
	AND c.packageid = p.id
	AND c.name NOT SIMILAR TO '[A-Z][a-zA-Z0-9\\_]*'
	AND c.name <> '<unknownClassType>'
	AND c.name <> ''
	AND c.kindOfType = tc.value
	AND (
		   tc.name LIKE 'TYPE_%CLASS' 
		OR tc.name LIKE 'TYPE_%DELEGATE'
		OR tc.name LIKE 'TYPE_%INTERFACE'
	)
	AND se.id = c.id
	AND se.sourcefileid <> -1
        AND se.sourceFileId = f.id 

UNION

/* Methoden */
SELECT DISTINCT
	'METHOD' AS type_of_element,
        p.fullname as package_fullname,
        c.fullname as class_fullname,
	m.name as element_name,
        f.pathname as file_name,
        se.startLine as line_number
FROM
	TMembers m,
	TTypes c,
	TPackages p,
	TSourceEntities se,
	TConstants tc,
	TSignatures sig, 
	TModelElements mm,
	TConstants cmm,
        TFiles f


WHERE
	mm.id = m.id
	AND mm.status = cmm.value
	AND cmm.name = 'STATUS_NORMAL'
	AND c.packageId = p.id
	AND m.classId = c.id
	AND m.name <> '<unknownMethod>'
	AND m.name NOT SIMILAR TO '[A-Z][a-zA-Z0-9\\_]*'
	AND m.kindOfMember = tc.value
	AND (
		   tc.name LIKE 'FUNC_METHOD'
		OR tc.name LIKE 'FUNC_GENERIC'
	)
	AND sig.functionId = m.id
	AND se.id = c.id
	AND se.sourceFileId <> -1
        AND se.sourceFileId = f.id 
	AND not exists (
		SELECT
			*
		FROM
			TMembers overriddenmember,
			TModelElements mElement,
			TConstants mCon
		WHERE
			    m.overridenmemberid = overriddenmember.id
			AND mElement.id = overriddenmember.id
			AND mCon.value = mElement.status
			AND mCon.name = 'STATUS_LIBRARY'
		)

UNION

/* Attribute und Konstanten*/
SELECT DISTINCT
	'FIELD' AS type_of_element,
        p.fullname as package_fullname,
        c.fullname as class_fullname,
	a.name as element_name,
        f.pathname as file_name,
        se.startLine as line_number
FROM
	TVariables a,
	TTypes c,
	TPackages p,
	TSourceEntities se,
	TConstants tc,
	TModelElements ma,
	TConstants cma,
        TFiles f

WHERE
	ma.id = a.id
	AND ma.status = cma.value
	AND cma.name = 'STATUS_NORMAL'
	AND c.packageId = p.id
	AND a.classId = c.id
	AND a.name <> '<self>'
	AND (
		   a.isConst = 0 AND a.name NOT SIMILAR TO '[a-z][a-zA-Z0-9\\_]*'
		OR a.isConst = 1 AND a.name NOT SIMILAR TO '[A-Z][A-Z0-9\\_]*'
	)
	AND a.kindOfVariable = tc.value
	AND tc.name LIKE 'VAR_FIELD'
	AND se.id = c.id
	AND se.sourceFileId <> -1
        AND se.sourceFileId = f.id 
   
UNION

/* Dateien */
SELECT DISTINCT
	'FILE' AS type_of_element,
        '' as package_fullname,
        '' as class_fullname,
	f.pathname as element_name,
        f.pathname as file_name,
        0 as line_number
FROM
	  TFiles f
	, TConstants tc
	, TModelElements mf
	, TConstants cmf

WHERE
	mf.id = f.id
	AND mf.status = cmf.value
	AND cmf.name = 'STATUS_NORMAL'
	AND tc.value = f.kindOfFile
	AND tc.name = 'FILE_SOURCE'
	AND f.pathName NOT SIMILAR TO '%[\\\\/][a-zA-Z][a-zA-Z0-9\\_]*\\.[a-zA-Z]+'
;	
	