

CREATE TABLE TInheritanceBetweenAbstractions AS

SELECT
	abstraction1.id AS id1,
	abstraction1.name AS name1,
	abstraction2.id AS id2,
	abstraction2.name AS name2,
	type1.id as subtypeid,
	type1.fullname as subtypefullname,
	type2.id as supertypeid,
	type2.fullname as supertypefullname
FROM
	TInheritances inheritance join
	TTypes type1 on (inheritance.classid = type1.id) join
	TSourceEntities sourceEntity1 on (type1.id = sourceEntity1.id) join
	TFiles file1 on (sourceEntity1.sourcefileid = file1.id) join
	TAbstractionElements abstractionElement1 on (file1.id = abstractionElement1.modelelementid) join 
	TAbstractions abstraction1 on (abstraction1.id = abstractionElement1.abstractionid AND abstraction1.type = 'Subsystem') join
	TTypes type2 on (inheritance.superid = type2.id) join
	TSourceEntities sourceEntity2 on (type2.id = sourceEntity2.id) join
	TFiles file2 on (sourceEntity2.sourcefileid = file2.id) join
	TAbstractionElements abstractionElement2 on (file2.id = abstractionElement2.modelelementid) join 
	TAbstractions abstraction2 on (abstraction2.id = abstractionElement2.abstractionid AND abstraction2.type = 'Subsystem') 
WHERE
	abstraction1.id <> abstraction2.id

;

CREATE TABLE TSubsystemAbstractionContainment AS

SELECT
	containerAbstraction.id as id1,
	containerAbstraction.name as name1,
	elementAbstraction.id as id2,
	elementAbstraction.name as name2
FROM
	TAbstractionElements abstractionElement,
	TAbstractions containerAbstraction,
	TAbstractions elementAbstraction,
	TConstants constant,
	TConstants constant2
WHERE
	abstractionElement.modelelementid = elementAbstraction.id
	AND abstractionElement.abstractionid = containerAbstraction.id
	AND constant.value = elementAbstraction.kindofabstraction
	AND constant.name = 'ABSTRACTION_SUBSYSTEM'
	AND constant2.name = 'ABSTRACTION_SUBSYSTEM'
;


SELECT
	containment.name1 as containing_subsystem_name,
	containment.name2 as contained_subsystem_name,
	inheritance.subtypefullname as subclass_full_name,
	inheritance.supertypefullname as superclass_full_name,
        filessub.pathname as subclass_file_name,
        srcsub.startline as subclass_line_number,
        filessuper.pathname as superclass_file_name,
        srcsuper.startline as superclass_line_number
FROM
	TSubsystemAbstractionContainment as containment join
	TInheritanceBetweenAbstractions as inheritance on (containment.id1 = inheritance.id1 AND containment.id2 = inheritance.id2) left outer join
        TSourceEntities srcsub on inheritance.subtypeid = srcsub.id left outer join
        TFiles filessub on srcsub.sourcefileid = filessub.id left outer join
        TSourceEntities srcsuper on inheritance.supertypeid = srcsuper.id left outer join
        TFiles filessuper on srcsuper.sourcefileid = filessuper.id
;

DROP TABLE TInheritanceBetweenAbstractions;
DROP TABLE TSubsystemAbstractionContainment;




